<?php
/**
 * The main template file.
 * 
 * @package MetroCorp
 * @since RadiumFramework 1.0.0
 */

get_header(); 

$framework = radium_framework();

$options = $framework->options;

radium_sidebar_loader( $options['post_archives_layout'] ); 

?>
<div class="row">
	<div id="main" class="<?php echo $radium_content_class; ?>" role="main">
	
	    <?php do_action('radium_before_content'); ?>
	    
		<div id="post-box">
			
			<?php if (have_posts()) : while (have_posts()) : the_post(); 
		
					$format = get_post_format(); 
					if( false === $format ) { $format = 'standard'; }
					if( $format == 'aside' || $format == 'gallery' || $format == 'image' || $format == 'link' || $format == 'quote' || $format == 'status') { }
				
				    get_template_part( 'includes/content/content', $format ); 
				
				endwhile; else : 
		
					get_template_part( 'includes/content/content', 'not-found' ); 
		
			 	endif; 
					
			if ( !function_exists( 'radium_theme_pagination' ) ) {
			
				 posts_nav_link();
			
			} else {
			
				echo radium_theme_pagination(); 
			
			} ?>
	
		</div><!-- #post-box -->
		
		<?php 
		    //after content action hook 
		    do_action('radium_after_content'); 
		?>
	
	</div><!-- #main -->
	 
	<?php if( $radium_sidebar_location === 'left' || $radium_sidebar_location === 'right' ) { ?>
	 
		<aside id="sidebar" class="<?php echo $radium_sidebar_class; ?>">
			<div id="sidebar-main" class="sidebar">
				<?php get_sidebar('Internal Sidebar'); ?>
			</div><!--sidebar-main-->
		</aside>
	
	<?php } ?>
</div>
<?php get_footer(); ?>
