<?php
/*-----------------------------------------------------------------------------------

 	Widget Name: Tabbed Content Widget
 	Widget URI: 
 	Description:  A widget that displays your recent portfolios.
 	Author: RadiumThemes
 	Author URI: http://radiumthemes.com
 	Version: 1.0
 
-----------------------------------------------------------------------------------*/

// Add function to widgets_init that'll load our widget.
add_action('widgets_init', 'radium_tabs_load_widgets');

// Register widget.
function radium_tabs_load_widgets() {
	register_widget('Radium_Tabs_Widget');
}

// Widget class
class Radium_Tabs_Widget extends WP_Widget {
	
	/**
	 * Register widget with WordPress.
	 */
	public function __construct() {
	
		$framework = radium_framework();
		
		parent::__construct(
	 		'radium_tabs_widget', // Base ID
			'Content Tabs ('. $framework->theme_title .')', // Name
			array( 'description' => __( 'Popular posts, recent post and comments..', 'radium' ), )
		);
	}
	
	/*-----------------------------------------------------------------------------------*/
	/*	Display Widget 
	/*-----------------------------------------------------------------------------------*/
		
	public function widget($args, $instance) {
		global $post;
		
		extract($args);
		
		//Set Thumbs
		$thumb_w 	= '48'; //Define width
		$thumb_h 	= '48'; // Define height
		$crop 		= true; //resize 
		$single 	= true; //return array
		
		$posts = $instance['posts'];
		$comments = $instance['comments'];
		$tags_count = $instance['tags'];
		$show_popular_posts = isset($instance['show_popular_posts']) ? 'true' : 'false';
		$show_recent_posts = isset($instance['show_recent_posts']) ? 'true' : 'false';
		$show_comments = isset($instance['show_comments']) ? 'true' : 'false';
		$show_tags = isset($instance['show_tags']) ? 'true' : 'false';
		
		echo $before_widget;
		?>
		<div class="tab-holder">
			<div class="tab-hold tabs-wrapper">
				<ul id="tabs" class="tabset tabs">
					<?php if($show_popular_posts == 'true'): ?>
						<li><a href="#tab1"><?php _e('Popular', 'radium'); ?></a></li>
					<?php endif; ?>
					<?php if($show_recent_posts == 'true'): ?>
						<li><a href="#tab2"><?php _e('Recent', 'radium'); ?></a></li>
					<?php endif; ?>
					<?php if($show_comments == 'true'): ?>
						<li><a href="#tab3"><?php _e('Comments', 'radium'); ?></a></li>
					<?php endif; ?>
				</ul>
				<div class="tab-box tabs-container">
					<?php if($show_popular_posts == 'true'): ?>
						<div id="tab1" class="tab tab_content" style="display: none;">
							<?php
							$popular_posts = new WP_Query('showposts='.$posts.'&orderby=comment_count&order=DESC');
							if($popular_posts->have_posts()): ?>
							<ul class="news-list">
								<?php while($popular_posts->have_posts()): $popular_posts->the_post(); 
				
										//Check if post has a featured image set else get the first image from the gallery and use it. If both statements are false display fallback image. 
										if ( has_post_thumbnail() ) {
											
											//get featured image
										    $thumb = get_post_thumbnail_id();
										    $img_url = wp_get_attachment_url( $thumb,'full' ); //get full URL to image (use "large" or "medium" if the image is too big)
										  
										} else {
										
											$attachments = get_children(
										        array(
										        	'post_parent' => get_the_ID(), 
										        	'post_type' => 'attachment', 
										        	'post_mime_type' => 'image', 
										        	'orderby' => 'menu_order'
										        	)
										    );
										    
										    if ( ! is_array($attachments) ) continue;
										    	$count = count($attachments);
										    	$first_attachment = array_shift($attachments);
										    
										     @$img_url = wp_get_attachment_url( $first_attachment->ID,'full' ); //get full URL to image (use "large" or "medium" if the image is too big)
										
										}
								
										$image = radium_resize($img_url, $thumb_w, $thumb_h, $crop, $single);
										
										//add thumbnail fallback
										if(empty($image)) $image = get_radium_first_post_image(true);
									
								
								?>
								<li class="clearfix">
									<div class="post-image">
										<a href="<?php the_permalink(); ?>">
											<img src="<?php echo $image ?>" alt=""/>
										</a>
									</div>
									<div class="post-holder">
										<a href="<?php the_permalink(); ?>"><strong><?php the_title(); ?></strong></a>
										<div class="meta">
											<?php the_date(); ?>
										</div>
									</div>
								</li>
								<?php endwhile; ?>
							</ul>
							<?php endif; ?>
						</div>
					<?php endif; ?>
					<?php if($show_recent_posts == 'true'): ?>
						<div id="tab2" class="tab tab_content" style="display: none;">
							<?php
							$recent_posts = new WP_Query('showposts='.$posts);
							if($recent_posts->have_posts()):
							?>
							<ul class="news-list">
								<?php while($recent_posts->have_posts()): $recent_posts->the_post();
									
									//Check if post has a featured image set else get the first image from the gallery and use it. If both statements are false display fallback image. 
									if ( has_post_thumbnail() ) {
										
										//get featured image
									    $thumb = get_post_thumbnail_id();
									    $img_url = wp_get_attachment_url( $thumb,'full' ); //get full URL to image (use "large" or "medium" if the image is too big)
									  
									} else {
									
										$attachments = get_children(
									        array(
									        	'post_parent' => get_the_ID(), 
									        	'post_type' => 'attachment', 
									        	'post_mime_type' => 'image', 
									        	'orderby' => 'menu_order'
									        	)
									    );
									    
									    if ( ! is_array($attachments) ) continue;
									    	$count = count($attachments);
									    	$first_attachment = array_shift($attachments);
									    	
									    if ($first_attachment )
									    	 @$img_url = wp_get_attachment_url( $first_attachment->ID,'full' ); //get full URL to image (use "large" or "medium" if the image is too big)
									
									}
							
									$image = radium_resize($img_url, $thumb_w, $thumb_h, $crop, $single);
									
									//add thumbnail fallback
									if(empty($image)) $image = get_radium_first_post_image(true);
								
								?>
								<li class="clearfix">
									<div class="post-image">
										<a href="<?php the_permalink(); ?>">
											<img src="<?php echo $image ?>" alt=""/>
										</a>
									</div>
									<div class="post-holder">
										<a href="<?php the_permalink(); ?>"><strong><?php the_title(); ?></strong></a>
										<div class="meta">
											<?php the_date(); ?>
										</div>
									</div>
								</li>
								<?php endwhile; ?>
							</ul>
							<?php endif; ?>
						</div>
					<?php endif; ?>
					
					<?php if($show_comments == 'true'): ?>
					
						<div id="tab3" class="tab tab_content" style="display: none;">
							<ul class="news-list">
								<?php
								$number = $instance['comments'];
								
								global $wpdb, $comments, $comment;
																	
								$number = 3;
								if($number < 1)
									$number = 1;
								else if($number > 15)
									$number = 15;
						
								if(!$comments = wp_cache_get('recent_comments', 'widget')) {
									
									$sql = "select * from $wpdb->comments where comment_approved = '1' order by comment_date_gmt DESC limit $number";
									$comments = $wpdb->get_results($sql);
									wp_cache_add('recent_comments', $comments, 'widget');
									
								}
									
								if($comments) : 
									foreach((array)$comments as $comment) :
										echo '<li class="recentcomments">';
					
										$url = get_comment_author_url();
										$author = get_comment_author();
					
										if( empty( $url ) || 'http://' == $url ) echo $author;
										else printf("<a href='$url' rel='external nofollow' class='url' %s>$author</a>", (''));
										printf(' on %s', '<a href="'. get_comment_link($comment->comment_ID) . '"><strong>' . get_the_title($comment->comment_post_ID) . '</strong></a>');
										
										echo '<br><span class="meta">' . get_the_time('F j Y') . '</span>';
											
										echo '</li>';
									endforeach; 
								endif;
									
								?>
							</ul>
						</div>
					<?php endif; ?>
					
				</div>
			</div>
		</div>
		
		<?php
		echo $after_widget;
	}
	
	function update($new_instance, $old_instance) 	{
		$instance = $old_instance;
		
		$instance['posts'] = $new_instance['posts'];
		$instance['comments'] = $new_instance['comments'];
		$instance['tags'] = $new_instance['tags'];
		$instance['show_popular_posts'] = $new_instance['show_popular_posts'];
		$instance['show_recent_posts'] = $new_instance['show_recent_posts'];
		$instance['show_comments'] = $new_instance['show_comments'];
		$instance['show_tags'] = $new_instance['show_tags'];
		
		return $instance;
	}

	function form($instance) {
		$defaults = array('posts' => 3, 'comments' => '3', 'tags' => 20, 'show_popular_posts' => 'on', 'show_recent_posts' => 'on', 'show_comments' => 'on', 'show_tags' =>  'on');
		$instance = wp_parse_args((array) $instance, $defaults); ?>
		<p>
			<label for="<?php echo $this->get_field_id('posts'); ?>"><?php _e('Number of popular posts:', 'radium'); ?></label>
			<input class="widefat" style="width: 30px;" id="<?php echo $this->get_field_id('posts'); ?>" name="<?php echo $this->get_field_name('posts'); ?>" value="<?php echo $instance['posts']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('tags'); ?>"><?php _e('Number of recent posts:', 'radium'); ?></label>
			<input class="widefat" style="width: 30px;" id="<?php echo $this->get_field_id('tags'); ?>" name="<?php echo $this->get_field_name('tags'); ?>" value="<?php echo $instance['tags']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('comments'); ?>"><?php _e('Number of comments:', 'radium'); ?></label>
			<input class="widefat" style="width: 30px;" id="<?php echo $this->get_field_id('comments'); ?>" name="<?php echo $this->get_field_name('comments'); ?>" value="<?php echo $instance['comments']; ?>" />
		</p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked($instance['show_popular_posts'], 'on'); ?> id="<?php echo $this->get_field_id('show_popular_posts'); ?>" name="<?php echo $this->get_field_name('show_popular_posts'); ?>" /> 
			<label for="<?php echo $this->get_field_id('show_popular_posts'); ?>"><?php _e('Show popular posts', 'radium'); ?></label>
		</p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked($instance['show_recent_posts'], 'on'); ?> id="<?php echo $this->get_field_id('show_recent_posts'); ?>" name="<?php echo $this->get_field_name('show_recent_posts'); ?>" /> 
			<label for="<?php echo $this->get_field_id('show_recent_posts'); ?>"><?php _e('Show recent posts', 'radium'); ?></label>
		</p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked($instance['show_comments'], 'on'); ?> id="<?php echo $this->get_field_id('show_comments'); ?>" name="<?php echo $this->get_field_name('show_comments'); ?>" /> 
			<label for="<?php echo $this->get_field_id('show_comments'); ?>"><?php _e('Show comments', 'radium'); ?></label>
		</p>
	<?php }
}
?>