<?php

// Add function to widgets_init that'll load our widget
add_action( 'widgets_init', 'radium_social_media_widgets' );

// Register widget
function radium_social_media_widgets() {
	register_widget( 'radium_Social_media_Widget' );
}

// Widget class
class radium_social_media_widget extends WP_Widget {


/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
 
/**
 * Register widget with WordPress.
 */
public function __construct() {

	$framework = radium_framework();
	
	parent::__construct(
 		'radium_social_media_widget', // Base ID
		'Social Media Widget ('. $framework->theme_title .')', // Name
		array( 'description' => __( 'A widget that allows the display of multiple social media icons.', 'radium' ), )
	);
}

/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
	
function widget( $args, $instance ) {
	extract( $args );

	// Our variables from the widget settings
	$title = apply_filters('widget_title', $instance['title'] );
	$style = $instance['style'];
	
	//icons
	$twitter = $instance['twitter'];
	$facebook = $instance['facebook'];
	$googleplus = $instance['googleplus'];
	$linkedin = $instance['linkedin'];
	$zerply = $instance['zerply'];
	$rss = $instance['rss'];
	$dribbble = $instance['dribbble'];
	$reddit = $instance['reddit'];
	$vimeo = $instance['vimeo'];
	$youtube = $instance['youtube'];
	$forrst = $instance['forrst'];
	$flickr = $instance['flickr'];
	$digg = $instance['digg'];
	$github = $instance['github'];
	$pinterest = $instance['pinterest'];
	$stumbleupon = $instance['stumbleupon'];
	$delicious = $instance['delicious'];
	$foursquare = $instance['foursquare'];
	$behance = $instance['behance'];
	$yelp = $instance['yelp'];
		
	// Before widget (defined by theme functions file)
	echo $before_widget;

	/* Display Widget */
	/* Display the widget title if one was input (before and after defined by themes). */
	if ( $title )
		echo $before_title . $title . $after_title;
	
		 $style = $style ? $style : 'dark' ;	
	
 	?>
	
	<div class="social-media-links">                        
	                   	
	    <ul <?php if ( $style ) { echo 'class="' .$style . '"'; } ?>>
			<?php if($twitter != '') : ?>
			    <li class="twitter">
			        <a href="<?php echo $twitter; ?>" title="Twitter"></a>
			    </li>
			<?php endif; ?>
			
			<?php if($facebook != '') : ?>
			    <li class="facebook">
			        <a href="<?php echo $facebook; ?>" title="Facebook"></a>
			    </li>
			<?php endif; ?>
			
			<?php if($googleplus != '') : ?>
			    <li class="googleplus">
			        <a href="<?php echo $googleplus; ?>" title="Google Plus"></a>
			    </li>
			<?php endif; ?>
			
			<?php if($linkedin != '') : ?>
			    <li class="linkedin">
			        <a href="<?php echo $linkedin; ?>" title="LinkedIn"></a>
			    </li>
			<?php endif; ?>
			
			<?php if($zerply != '') : ?>
			    <li class="zerply">
			        <a href="<?php echo $zerply; ?>" title="Zerply"></a>
			    </li>
			<?php endif; ?>
			
			<?php if($rss != '') : ?>
			    <li class="rss">
			        <a href="<?php echo $rss; ?>" title="RSS Feed"></a>
			    </li>
			<?php endif; ?>
			
			<?php if($dribbble != '') : ?>
			    <li class="dribbble">
			        <a href="<?php echo $dribbble; ?>" title="Dribbble"></a>
			    </li>
			<?php endif; ?>
			
			<?php if($reddit != '') : ?>
				<li class="reddit">
				    <a href="<?php echo $reddit; ?>" title="Reddit"></a>
				</li>
			<?php endif; ?>
			
			<?php if($vimeo != '') : ?>
			    <li class="vimeo">
			        <a href="<?php echo $vimeo; ?>" title="Vimeo"></a>
			    </li>
			<?php endif; ?>
			
			<?php if($youtube != '') : ?>
			    <li class="youtube">
			        <a href="<?php echo $youtube; ?>" title="YouTube"></a>
			    </li>
			<?php endif; ?>
			
			<?php if($forrst != '') : ?>
			    <li class="forrst">
			        <a href="<?php echo $forrst; ?>" title="Forrst"></a>
			    </li>
			<?php endif; ?>
			
			<?php if($flickr != '') : ?>
			    <li class="flickr">
			        <a href="<?php echo $flickr; ?>" title="Flickr"></a>
			    </li>
			<?php endif; ?>
			
			<?php if($digg != '') : ?>
			    <li class="digg">
			        <a href="<?php echo $digg; ?>" title="Digg"></a>
			    </li>
			<?php endif; ?>
			
			<?php if($github != '') : ?>
			    <li class="github">
			        <a href="<?php echo $github; ?>" title="Github"></a>
			    </li>
			<?php endif; ?>
			
			<?php if($pinterest != '') : ?>
			    <li class="pinterest">
			        <a href="<?php echo $pinterest; ?>" title="Pinterest"></a>
			    </li>
			<?php endif; ?>
			
			<?php if($stumbleupon != '') : ?>
			    <li class="stumbleupon">
			        <a href="<?php echo $stumbleupon; ?>" title="Stumble Upon"></a>
			    </li>
			<?php endif; ?>
			
			<?php if($delicious != '') : ?>
			    <li class="delicious">
			        <a href="<?php echo $delicious; ?>" title="Delicious"></a>
			    </li>
			<?php endif; ?>
			
			<?php if($foursquare != '') : ?>
			    <li class="foursquare">
			        <a href="<?php echo $foursquare; ?>" title="FourSquare"></a>
			    </li>
			<?php endif; ?>
			
			<?php if($behance != '') : ?>
			    <li class="behance">
			        <a href="<?php echo $behance; ?>" title="Behance"></a>
			    </li>
			<?php endif; ?>
			
			<?php if($yelp != '') : ?>
			    <li class="yelp">
			        <a href="<?php echo $yelp; ?>" title="Yelp"></a>
			    </li>
			<?php endif; ?>
		</ul>		
	</div>			
	
	<?php
		
	// After widget (defined by theme functions file)
	echo $after_widget;
	
}


/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	
function update( $new_instance, $old_instance ) {
	$instance = $old_instance;

	// Strip tags to remove HTML (important for text inputs)
	$instance['title'] = strip_tags( $new_instance['title'] );
	$instance['style'] = strip_tags( $new_instance['style'] );
	
	// No need to strip tags
	$instance['twitter'] = $new_instance['twitter'];
	$instance['facebook'] = $new_instance['facebook'];
	$instance['googleplus'] = $new_instance['googleplus'];
	$instance['linkedin'] = $new_instance['linkedin'];
	$instance['zerply'] = $new_instance['zerply'];
	$instance['rss'] = $new_instance['rss'];
	$instance['dribbble'] = $new_instance['dribbble'];
	$instance['reddit'] = $new_instance['reddit'];
	$instance['vimeo'] = $new_instance['vimeo'];
	$instance['youtube'] = $new_instance['youtube'];
	$instance['forrst'] = $new_instance['forrst'];
	$instance['flickr'] = $new_instance['flickr'];
	$instance['digg'] = $new_instance['digg'];
	$instance['github'] = $new_instance['github'];
	$instance['pinterest'] = $new_instance['pinterest'];
	$instance['stumbleupon'] = $new_instance['stumbleupon'];
	$instance['delicious'] = $new_instance['delicious'];
	$instance['foursquare'] = $new_instance['foursquare'];
	$instance['behance'] = $new_instance['behance'];
	$instance['yelp'] = $new_instance['yelp'];
			
	return $instance;
}

/*-----------------------------------------------------------------------------------*/
/*	Widget Settings (Displays the widget settings controls on the widget panel)
/*-----------------------------------------------------------------------------------*/
	
function form( $instance ) {

	// Set up some default widget settings
	$style = $instance[ 'style' ];
	
	$defaults = array(
		'title' => 'Connect with Us.',	
		'twitter' => '',
		'facebook' => '',
		'googleplus' => '',
		'linkedin' => '',
		'zerply' => '',
		'rss' => '',
		'dribbble' => '',
		'reddit' => '',
		'vimeo' => '',
		'youtube' => '',
		'forrst' => '',
		'flickr' => '',
		'digg' => '',
		'github' => '',
		'pinterest' => '',
		'stumbleupon' => '',
		'delicious' => '',
		'foursquare' => '',
		'behance' => '',
		'yelp' => '',
	);
		
	$instance = wp_parse_args( (array) $instance, $defaults ); ?>
 	
	<p><!-- Widget Title: Text Input -->
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
	</p>
	<p>
		<label for="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>"><?php _e( 'Choose a Style: ', 'radium' ); ?></label>
		<select id="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'style' ) ); ?>">
			<option value="style1" <?php selected( 'style1', $style ); ?>><?php _e( 'Style 1 (Default)', 'radium' ); ?></option>
			<option value="style2" <?php selected( 'style2', $style ); ?>><?php _e( 'Style 2 (Social Colors)', 'radium' ); ?></option>
			<option value="style3" <?php selected( 'style3', $style ); ?>><?php _e( 'Style 3 (Icons)', 'radium' ); ?></option>
			<option value="dark" <?php selected( 'dark', $style ); ?>><?php _e( 'Style 4 (Dark)', 'radium' ); ?></option>
		</select>
	</p>
	<br>
	<p><strong>Input your social links below: </strong></p>
	
	<p><!-- Begin Social Media Input -->
		<label for="<?php echo $this->get_field_id( 'behance' ); ?>"><?php _e('1. Behance URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'behance' ); ?>" name="<?php echo $this->get_field_name( 'behance' ); ?>" value="<?php echo $instance['behance']; ?>" />
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id( 'delicious' ); ?>"><?php _e('2. Delicious URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'delicious' ); ?>" name="<?php echo $this->get_field_name( 'delicious' ); ?>" value="<?php echo $instance['delicious']; ?>" />
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id( 'digg' ); ?>"><?php _e('3. Digg URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'digg' ); ?>" name="<?php echo $this->get_field_name( 'digg' ); ?>" value="<?php echo $instance['digg']; ?>" />
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id( 'dribbble' ); ?>"><?php _e('4. Dribbble URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'dribbble' ); ?>" name="<?php echo $this->get_field_name( 'dribbble' ); ?>" value="<?php echo $instance['dribbble']; ?>" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'facebook' ); ?>"><?php _e('5. Facebook URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'facebook' ); ?>" name="<?php echo $this->get_field_name( 'facebook' ); ?>" value="<?php echo $instance['facebook']; ?>" />
	</p>	
	
	<p>
		<label for="<?php echo $this->get_field_id( 'flickr' ); ?>"><?php _e('6. Flickr URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'flickr' ); ?>" name="<?php echo $this->get_field_name( 'flickr' ); ?>" value="<?php echo $instance['flickr']; ?>" />
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id( 'forrst' ); ?>"><?php _e('7. Forrst URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'forrst' ); ?>" name="<?php echo $this->get_field_name( 'forrst' ); ?>" value="<?php echo $instance['forrst']; ?>" />
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id( 'foursquare' ); ?>"><?php _e('8. FourSquare URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'foursquare' ); ?>" name="<?php echo $this->get_field_name( 'foursquare' ); ?>" value="<?php echo $instance['foursquare']; ?>" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'github' ); ?>"><?php _e('9. Github URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'github' ); ?>" name="<?php echo $this->get_field_name( 'github' ); ?>" value="<?php echo $instance['github']; ?>" />
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id( 'googleplus' ); ?>"><?php _e('10. Google Plus URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'googleplus' ); ?>" name="<?php echo $this->get_field_name( 'googleplus' ); ?>" value="<?php echo $instance['googleplus']; ?>" />
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id( 'linkedin' ); ?>"><?php _e('11. LinkedIn URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'linkedin' ); ?>" name="<?php echo $this->get_field_name( 'linkedin' ); ?>" value="<?php echo $instance['linkedin']; ?>" />
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id( 'pinterest' ); ?>"><?php _e('12. Pinterest URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'pinterest' ); ?>" name="<?php echo $this->get_field_name( 'pinterest' ); ?>" value="<?php echo $instance['pinterest']; ?>" />
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id( 'reddit' ); ?>"><?php _e('13. Reddit URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'reddit' ); ?>" name="<?php echo $this->get_field_name( 'reddit' ); ?>" value="<?php echo $instance['reddit']; ?>" />
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id( 'rss' ); ?>"><?php _e('14. RSS URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'rss' ); ?>" name="<?php echo $this->get_field_name( 'rss' ); ?>" value="<?php echo $instance['rss']; ?>" />
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id( 'stumbleupon' ); ?>"><?php _e('15. StumbleUpon URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'stumbleupon' ); ?>" name="<?php echo $this->get_field_name( 'stumbleupon' ); ?>" value="<?php echo $instance['stumbleupon']; ?>" />
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id( 'twitter' ); ?>"><?php _e('16. Twitter URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'twitter' ); ?>" name="<?php echo $this->get_field_name( 'twitter' ); ?>" value="<?php echo $instance['twitter']; ?>" />
	</p>
		
	<p>
		<label for="<?php echo $this->get_field_id( 'vimeo' ); ?>"><?php _e('17. Vimeo URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'vimeo' ); ?>" name="<?php echo $this->get_field_name( 'vimeo' ); ?>" value="<?php echo $instance['vimeo']; ?>" />
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id( 'yelp' ); ?>"><?php _e('18. Yelp URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'yelp' ); ?>" name="<?php echo $this->get_field_name( 'yelp' ); ?>" value="<?php echo $instance['yelp']; ?>" />
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id( 'youtube' ); ?>"><?php _e('19. YouTube URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'youtube' ); ?>" name="<?php echo $this->get_field_name( 'youtube' ); ?>" value="<?php echo $instance['youtube']; ?>" />
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id( 'zerply' ); ?>"><?php _e('20. Zerply URL:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'zerply' ); ?>" name="<?php echo $this->get_field_name( 'zerply' ); ?>" value="<?php echo $instance['zerply']; ?>" />
	</p>
  	
	<br>
		
	<?php
	}
}
?>