<?php

class Radium_Shortcodes {

    function __construct() {
    	
    	$framework = radium_framework();
    	
    	require_once( $framework->theme_shortcodes_dir .'/theme-shortcodes.php' );
    	
    	define('RADIUM_TINYMCE_URI', $framework->theme_shortcodes_url .'/tinymce');
		define('RADIUM_TINYMCE_DIR', $framework->theme_shortcodes_dir .'/tinymce');
		
        add_action('init', array(&$this, 'action_admin_init'));
        
        add_action('admin_enqueue_scripts', array(&$this, 'action_admin_scripts_init'));
        add_action('wp_enqueue_scripts', array(&$this, 'action_frontend_scripts'));
        
	}
	
	/**
	 * Registers Scripts
	 *
	 * @return	void
	 */
	 
	function action_frontend_scripts() {
	//Load Scripts here
	
	}
	
	/**
	 * Enqueue Scripts and Styles
	 *
	 * @return	void
	 */
	function action_admin_scripts_init() {
	    
	    $framework = radium_framework();
	
		// css
		wp_enqueue_style( 'radium-popup', RADIUM_TINYMCE_URI . '/css/popup.css', false, '1.0', 'all' );
		
		// js
		wp_enqueue_script( 'jquery-ui-sortable' );
		wp_enqueue_script( 'jquery-livequery', RADIUM_TINYMCE_URI . '/js/jquery.livequery.js', false, '1.1.1', false );
		wp_enqueue_script( 'jquery-appendo', RADIUM_TINYMCE_URI . '/js/jquery.appendo.js', false, '1.0', false );
		wp_enqueue_script( 'base64', RADIUM_TINYMCE_URI . '/js/base64.js', false, '1.0', false );
		wp_enqueue_script( 'radium-popup', RADIUM_TINYMCE_URI . '/js/popup.js', false, '1.0', false );
		wp_localize_script( 'jquery', 'RadiumShortcodes', array('plugin_folder' => $framework->theme_shortcodes_url) );
	}
	
	/**
	 * Registers TinyMCE rich editor buttons
	 *
	 * @return	void
	 */
	function action_admin_init() {

		if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') )
			return;
	
		if ( get_user_option('rich_editing') == 'true' && is_admin() ) {
			add_filter( 'mce_external_plugins', array(&$this, 'add_rich_plugins') );
			add_filter( 'mce_buttons', array(&$this, 'register_rich_buttons') );
		}
	}
	
	// --------------------------------------------------------------------------
	
	/**
	 * Defines TinyMCE rich editor js plugin
	 *
	 * @return	void
	 */
	function add_rich_plugins( $plugin_array ) {
	
		$plugin_array['radiumShortcodes'] = RADIUM_TINYMCE_URI . '/plugin.js';
		
		return $plugin_array;
	}
	
	// --------------------------------------------------------------------------
	
	/**
	 * Adds TinyMCE rich editor buttons
	 *
	 * @return	void
	 */
	function register_rich_buttons( $buttons ) {
	
		array_push( $buttons, "|", 'radium_button' );
		
		return $buttons;
	}
    
}

$radium_shortcodes = new Radium_Shortcodes();

?>