<?php

$framework = radium_framework();

if ( !function_exists( 'radium_load_framework_theme_options') ) {

function radium_load_framework_theme_options() {
	
	$framework = radium_framework();
	
	/* Fields 
		'id' => 'logo', //must be unique
		'type' => 'upload', //built-in fields include:
						  //text|textarea|editor|checkbox|multi_checkbox|radio|radio_img|button_set|select|multi_select|color|date|divide|info|upload
		'title' => __('Upload Logo', 'radium'),
		'sub_desc' => __('This is a little space under the Field Title in the Options table, additional info is good in here.', 'radium'),
		'desc' => __('This is the description field, again good for additional info.', 'radium'),
		'validate' => '', //built-in validation includes: email|html|html_custom|no_html|js|numeric|url
		'msg' => 'custom error message', //override the default validation error message for specific fields
		'std' => '', //This is a default value, used to set the options on theme activation, and if the user hits the Reset to defaults Button
		'class' => '' //Set custom classes for elements if you want to do something a little different - default is "regular-text"
		), 
	*/
	/*
	$sections[] = array(
					'title'		=> __('Getting Started', 'radium'),
					//'desc' 	=> __('<p class="description">Welcome to '.$framework->theme_title.' If you have any problems, click <a href="'.$framework->theme_support_url .'" target="_blank">here</a> for the Support Forum. Feel free to check out our other Premium WordPress Themes on Themeforest <a href="http://themeforest.net/user/FranklinM2?ref=FranklinM2" target="_blank">here</a></p>', 'radium'),
					'desc' 		=>'',
					'icon' 		=> RADIUM_OPTIONS_URL.'assets/images/icons/icon-attach.png',
					'fields' 	=> array(
												
						array(
							'id' => 'Import_content',
							'type' => 'importer', 
							'title' => __('Import Demo Content', 'radium'),
							'sub_desc' => __('If you are new to Wordpress or have problems creating posts or pages that look like the theme preview you can import dummy posts and pages here that will definitely help to understand how those tasks are done.', 'radium'),
							),
								
						array(
							'id' => 'hide_intro',
							'type' => 'checkbox',
							'title' => __('Hide this section in the future.', 'radium'),
							'desc' => __('', 'radium'),
							'std' => 0
							),	
					) 
	 			);
	 			
	*/
				
$sections[] = array(
				'icon' => RADIUM_OPTIONS_URL.'assets/images/icons/icon-settings.png',
				'title' => __('General Options', 'radium'),
				'desc' => __(' ', 'radium'),
				'fields' => array(
  
					array(
						'id' => 'layout_type',
						'type' => 'radio_img',
						'title' => __('Select Theme Layout', 'radium'), 
						'sub_desc' => __('Wide (fullwidth) or boxed (940px wide)', 'radium'),
							'options' => array(
									'wide' 	=> array('title' 	=> 'Wide Layout', 'img'      	=> RADIUM_OPTIONS_URL.'assets/images/wide.png'),
									'boxed' => array('title' 	=> 'Boxed Layout ', 'img'      	=> RADIUM_OPTIONS_URL.'assets/images/boxed.png'),
								),//Must provide key => value(array:title|img) pairs for radio options
						'std' => 'boxed'
					),
					
					array(
						'id' => 'logo',
						'type' => 'upload', 
						'title' => __('Upload Logo', 'radium'),
						'sub_desc' => __('Upload you custom logo here.  This will override the default. If empty, the site title will be displayed.', 'radium'),
						),
 					
					array(
						'id' => 'favicon',
						'type' => 'upload', 
						'title' => __('Upload Favicon', 'radium'),
						'sub_desc' => __('Upload a favicon here. This will override the default. It should be 16px by 16px.', 'radium'),
						),
					
					array(
						'id' => 'site_description',
						'type' => 'checkbox',
						'title' => __('Enable Site description', 'radium'),
						'desc' => __('Show the site description next to the logo.', 'radium'),
						'std' => 1,
						'switch' => true,
						),
						
					array(
						'id' => 'appleicon',
						'type' => 'upload', 
						'title' => __('Upload Apple Touch Icon', 'radium'),
						'sub_desc' => __('Upload you custom icon here. It should be 114px by 114px.', 'radium'),
						),
						
					array(
						'id' => 'enable_message_bar',
						'type' => 'checkbox_hide_below',
						'title' => __('Show/Hide Message Overlay', 'radium'),
						'desc' => __('Show or hide message overlay.', 'radium'),
						'std' => 1,
						'switch' => true,
						),

					array(
						'id' => 'message_bar_text',
						'type' => 'textarea',
						'title' => __('Message Overlay', 'radium'),
						'sub_desc' => __('Enter your message here and it will be displayed on all pages. (HTML is allowed).', 'radium'),
 						'validate' => 'html', //see http://codex.wordpress.org/Function_Reference/wp_kses_post
						'std' => 'Hey!'
						),
						
					array(
						'id' => 'header_analytics',
						'type' => 'textarea',
						'title' => __('Header Analytics.', 'radium'),
						'sub_desc' => __('Paste any analytics code that belongs in the head element of your site here.', 'radium'),
						'std' => ''
						),
					
					array(
						'id' => 'other_analytics',
						'type' => 'textarea',
						'title' => __('Footer Analytics', 'radium'),
						'sub_desc' => __('Paste any analytics code that belongs before the closing body tag here.', 'radium'),
						'std' => ''
						),
						
					array(
						'id' => 'feedburner_url',
						'type' => 'text',
						'title' => __('Feedburner Url', 'radium'),
						'sub_desc' => __('This will be added to the feed urls in the header section', 'radium'),
						'std' => ''
						),										
					
					array(
						'id' => 'footer_copyright_text',
						'type' => 'textarea',
						'title' => __('Footer Copyright Text', 'radium'),
						'sub_desc' => __('html is allowed', 'radium'),
						'std' => '<div id="copyright">Copyright &#64; '. date('Y').'<a href="http://radiumthemes.com"> A Radium Themes Creations</a> - All Rights Reserved.</div>'
						),	
   					)
				);
				
$sections[] = array(
				'icon' => RADIUM_OPTIONS_URL.'assets/images/icons/icon-page.png',
				'title' => __('Page Settings', 'radium'),
				'desc' => __(' ', 'radium'),
				'fields' => array(
 					
 					/*array(
 					    'id' => 'header_fonts',
 					    'type' => 'google_webfonts',
 					    'title' => __('Header Webfonts', 'radium'), 
 					    'sub_desc' => __('Choose a font for the headers. Powered by Google fonts', 'radium'),
 					    'desc' => __('', 'radium')
 					),  */
 					
					array(
						'id' => 'post_tags',
						'type' => 'multi_checkbox',
						'title' => __( 'Show Tags', 'radium'), 
						'sub_desc' => __('Select pages to show tags on.', 'radium'),
						'options' => array(
							'posts'     => 'Posts',
							'portfolio' => 'Portfolio',
						),
						'std' => array(
							'posts'     => '1', 
							'portfolio' => '0', 
						)
					),
					
					array(
						'id' => 'author_info',
						'type' => 'checkbox',
						'title' => __('Show Author Details in Posts', 'radium'), 
 						'desc' => __('This will show the author\'s description set in the profile settings.', 'radium'),
						'std' => '1',
						'switch' => true,
 						),
						
					array(
						'id' => 'related_posts_type',
						'type' => 'select',
						'title' => __('Related Content Type', 'radium'), 
						'sub_desc' => __('Related content type by tags or category', 'radium'),
 						'options' => array( 
 							'tags' => 'Tags', 
 							'cat'  => 'Category'
 						),
						'std' => 'tags'
					),
 						
					array(
						'id' => 'related_posts',
						'type' => 'multi_checkbox',
						'title' => __( 'Show Related Content', 'radium'), 
						'sub_desc' => __('Select pages to show related content on.', 'radium'),
						'options' => array(
							'posts'     => 'Posts',
							'portfolio' => 'Portfolio',
						),
						'std' => array(
							'posts'     => '1', 
							'portfolio' => '1', 
						)
					),
								
					array(
						'id' => 'share_post',
						'type' => 'multi_checkbox',
						'title' => __( 'Show Share Buttons on Single Posts', 'radium'), 
 						'sub_desc' => __('Select which social share buttons are displayed in the blog single posts.', 'radium'),
						'options' => array(
							'facebook'  => 'Facebook',
							'twitter'   => 'Twitter',
							'pinterest' => 'Pinterest', 
							'google+'   => 'Google+'
						),
						'std' => array(
							'facebook'  => '0', 
							'twitter'   => '0', 
							'pinterest' => '0', 
							'google+'   => '0'
						)//See how std has changed? you also don't need to specify opts that are 0.
					),
 
					array(
						'id' => '404_page_content',
						'type' => 'editor',
						'title' => __('404 Page Content.', 'radium'),
						'sub_desc' => __('Page not found custom message', 'radium'),
						'std' => __( '<h1 class="entry-title">This is somewhat embarrassing, isn&rsquo;t it?</h1><p>Sorry, but the page you were trying to view cannot be found. <br>It looks like this was the result of either:</p><ul><li>A mistyped address</li><li>An out-of-date link</li></ul><p>Other things to try: <br> Search '.home_url(), 'radium')
						),										
				)
			);

$sections[] = array(
				'title' => __('Layout', 'radium'),
				'desc' => __(' ', 'radium'),
 				'icon' => RADIUM_OPTIONS_URL.'assets/images/icons/icon-layout.png',
 				'fields' => array(
						array(
							'id' => 'single_post_layout',
							'type' => 'radio_img',
							'title' => __('Single Post Layout', 'radium'), 
							'sub_desc' => __('Select a layout for single posts.', 'radium'),
								'options' => array(
											'right' 	=> array('title' 	=> '2 col right', 'img'      	=> RADIUM_OPTIONS_URL.'assets/images/2cr.png'),
											'left' 		=> array('title' 	=> '2 col left ', 'img'      	=> RADIUM_OPTIONS_URL.'assets/images/2cl.png'),
											'none' 		=> array('title'	=> '1 col no sidebar', 'img' 	=> RADIUM_OPTIONS_URL.'assets/images/1col.png')
										),//Must provide key => value(array:title|img) pairs for radio options
							'std' => 'right'
						),
						array(
							'id' => 'post_archives_layout',
							'type' => 'radio_img',
							'title' => __('Post Archives Layout', 'radium'), 
							'sub_desc' => __('Select a layout for Post Archives.', 'radium'),
								'options' => array(
									'right' 	=> array('title' 	=> '2 col right', 'img'      	=> RADIUM_OPTIONS_URL.'assets/images/2cr.png'),
									'left' 		=> array('title' 	=> '2 col left ', 'img'      	=> RADIUM_OPTIONS_URL.'assets/images/2cl.png'),
									'none' 		=> array('title'	=> '1 col no sidebar', 'img' 	=> RADIUM_OPTIONS_URL.'assets/images/1col.png')
											),//Must provide key => value(array:title|img) pairs for radio options
							'std' => 'right'
						),
								
						array(
							'id' => 'footer_layout',
							'type' => 'radio_img',
							'title' => __('Footer Layout', 'radium'), 
							'sub_desc' => __('Select a layout for the footer.', 'radium'),
								'options' => array(
									'none' 			=> array('title'	=> 'none',  'img' 				=> RADIUM_OPTIONS_URL.'assets/images/footer-widgets-0.png'),
									'100' 			=> array('title' 	=> '1 col', 'img'      			=> RADIUM_OPTIONS_URL.'assets/images/footer-widgets-1.png'),
									'50-50' 		=> array('title' 	=> '2 col', 'img'      			=> RADIUM_OPTIONS_URL.'assets/images/footer-widgets-2.png'),
									'33-33-33' 		=> array('title'	=> '3 col', 'img' 				=> RADIUM_OPTIONS_URL.'assets/images/footer-widgets-3.png'),
									'25-25-25-25'	=> array('title'	=> '4 col', 'img' 				=> RADIUM_OPTIONS_URL.'assets/images/footer-widgets-4.png')
								),//Must provide key => value(array:title|img) pairs for radio options
							'std' => '50-25-25'
						),
					
					)
  				);

$sections[] = array(
				'icon' => RADIUM_OPTIONS_URL.'assets/images/icons/icon-settings.png',
				'title' => __('Custom Styles', 'radium'),
				'desc' => __(' ', 'radium'),
				'fields' => array(
				
					/**
					 * General Color customization
					 */
					 
					 array(
					 	'id' => 'body_bg_pattern',
					 	'type' => 'radio_img',
					 	'title' => __('Background Styles', 'radium'), 
					 	'sub_desc' => __('Select a background style for the <strong>boxed</strong> layout.', 'radium'),
					 		'options' => array(
					 			'pattern_rad.png' => array(
					 				'title' => 'Default', 
					 				'img' => $framework->theme_images_url.'/patterns/pattern_rad.png'
					 			),
					 			'crissxcross.png' => array(
					 				'title' => 'CrissXcross', 
					 				'img' => $framework->theme_images_url.'/patterns/crissxcross.png'
					 			),
					 			'crossed_stripes.png' => array(
					 				'title' => 'Crossed_stripes', 
					 				'img' => $framework->theme_images_url.'/patterns/crossed_stripes.png'
					 			),
					 			'crosses.png' => array(
					 				'title' => 'Crosses', 
					 				'img' => $framework->theme_images_url.'/patterns/crosses.png'
					 			),
					 			'cubes.png' => array(
					 				'title' => 'Cubes', 
					 				'img' => $framework->theme_images_url.'/patterns/cubes.png'
					 			),
					 			'diagmonds.png' => array(
					 				'title' => 'Diagmonds', 
					 				'img' => $framework->theme_images_url.'/patterns/diagmonds.png'
					 			),
					 			'dark.jpg' => array(
					 				'title' => 'Dark', 
					 				'img' => $framework->theme_images_url.'/patterns/dark.jpg'
					 			),
					 			'fabric.jpg' => array(
					 				'title' => 'Fabric', 
					 				'img' => $framework->theme_images_url.'/patterns/fabric.jpg'
					 			),
					 			'graphy.png' => array(
					 				'title' => 'Graphy', 
					 				'img' => $framework->theme_images_url.'/patterns/graphy.png'
					 			),
					 			'kuji.png' => array(
					 				'title' => 'Kuji', 
					 				'img' => $framework->theme_images_url.'/patterns/kuji.png'
					 			),
					 			'micro_carbon.png' => array(
					 				'title' => 'Micro-carbon', 
					 				'img' => $framework->theme_images_url.'/patterns/micro_carbon.png'
					 			),
					 			'padded.png' => array(
					 				'title' => 'Padded', 
					 				'img' => $framework->theme_images_url.'/patterns/padded.png'
					 			),
					 			'plaid.png' => array(
					 				'title' => 'Plaid', 
					 				'img' => $framework->theme_images_url.'/patterns/plaid.png'
					 			),
					 			'project_papper.png' => array(
					 				'title' => 'Project papper', 
					 				'img' => $framework->theme_images_url.'/patterns/project_papper.png'
					 			),
					 			'px_by_gre3g.png' => array(
					 				'title' => 'Px_by_Gre3g', 
					 				'img' => $framework->theme_images_url.'/patterns/px_by_gre3g.png'
					 			),
					 			'random_grey_variations.png' => array(
					 				'title' => 'Random grey variations', 
					 				'img' => $framework->theme_images_url.'/patterns/random_grey_variations.png'
					 			),
					 			'vichy.png' => array(
					 				'title' => 'Vichy', 
					 				'img' => $framework->theme_images_url.'/patterns/vichy.png'
					 			),
					 			'wood_pattern_trans.png' => array(
					 				'title' => 'Wood pattern transparent', 
					 				'img' => $framework->theme_images_url.'/patterns/wood_pattern_trans.png'
					 			),
					 			'wood_pattern.png' => array(
					 				'title' => 'Wood pattern', 
					 				'img' => $framework->theme_images_url.'/patterns/wood_pattern.png'
					 			),
					 			'xv.png' => array(
					 				'title' => 'XV', 
					 				'img' => $framework->theme_images_url.'/patterns/xv.png'
					 			),
					 			'' => array(
					 				'title' => 'None', 
					 				'img' => $framework->theme_images_url.'/patterns/none.png'
					 			)
					 		),//Must provide key => value(array:title|img) pairs for radio options
					 	'std' => ''
					 	),
					 
					 array(
					 	'id' => 'main_bg',
					 	'type' => 'upload', 
					 	'title' => __('Upload a background image', 'radium'),
					 	'sub_desc' => __('Upload an image to be used a the background here. This will override the ones above.', 'radium'),
					 	),
					 	
				 	array(
				 		'id' => 'main_bg_setting',
				 		'type' => 'select',
				 		'title' => __('Background Image settings', 'radium'), 
				 		'sub_desc' => __('', 'radium'),
				 			'options' => array( 
				 				'repeat' 	=> 'Repeat', 
				 				'fullwidth' => 'Fullwidth'
				 			),
				 		'std' => 'fullwidth'
				 	),
				 		
					 array(
					 	'id' => 'accent_color',
					 	'type' => 'color',
					 	'title' => __('Accent Color', 'radium'), 
					 	'sub_desc' => __('main theme color.', 'radium'),
					 	'std' => ''
					 	),
					 array(
					 	'id' => 'boxed_bg_color',
					 	'type' => 'color',
					 	'title' => __('Background Color', 'radium'), 
					 	'sub_desc' => __('Boxed layout background color.', 'radium'),
					 	'std' => ''
					 	),
					array(
						'id' => 'header_bg_color',
						'type' => 'color',
						'title' => __('Header Background Color', 'radium'), 
						'desc' => __(' ', 'radium'),
						'std' => ''
						),
					array(
						'id' => 'footer_bg_color',
						'type' => 'color',
						'title' => __('Footer Background Color', 'radium'), 
						'desc' => __(' ', 'radium'),
						'std' => ''
						),
		
 					/**
 					 * Custom Css
 					 */ 
					array(
						'id' => 'user_custom_styles',
						'type' => 'textarea',
						'title' => __('Add Custom CSS', 'radium'),
						'sub_desc' => __('Place more custom css here. Don&#39;t wrap it in &#60;style&#62; tags', 'radium'),
						'std' => ''
						),
					)
				);
				
  return $sections;
  
}//function

add_filter('radium-opts-sections-'.$framework->theme_option_name, 'radium_load_framework_theme_options');

}


/**
 * Get recognized font faces.
 *
 * Returns an array of all recognized font faces.
 * Keys are intended to be stored in the database
 * while values are ready for display in in html.
 *
 * @return   array
 *
 */
if( ! function_exists( 'radium_recognized_font_faces' ) ) {
	function radium_recognized_font_faces() {
		$default = array(
			'arial'     	=> 'Arial',
			'baskerville'	=> 'Baskerville',
			'georgia'   	=> 'Georgia',
			'helvetica' 	=> 'Helvetica*',
			'lucida'  		=> 'Lucida Sans',
			'palatino'  	=> 'Palatino',
			'tahoma'    	=> 'Tahoma, Geneva',
			'times'     	=> 'Times New Roman',
			'trebuchet' 	=> 'Trebuchet',
			'verdana'   	=> 'Verdana, Geneva',
			'google'		=> 'Google Font'
		);
		return apply_filters( 'radium_recognized_font_faces', $default );
	}
}
/**
 * Setup theme for customizer options.
 */
 
if( ! function_exists( 'singleton_customizer' ) && $framework->theme_supports('primary', 'skins') ) {
	function singleton_customizer(){
		// Setup General options
		$general_options = array(
			 
			'layout_type' => array( 
				'name' 		=> __( 'Theme Layout', 'radium' ),
				'id'		=> 'layout_type',
				'type' 		=> 'select',
				'options'	=> array(
					'wide' 			=> __( 'Wide', 'radium' ),
					'boxed' 		=> __( 'Boxed', 'radium' ),
				),
				'transport'	=> 'postMessage'
			)
		);
		radium_add_customizer_section( 'general', __( 'General', 'radium' ), $general_options, 1 );
		
		// Setup logo options
		$header_options = array(
			'logo' => array( 
				'name' 		=> __( 'Logo', 'radium' ),
				'id' 		=> 'logo',
				'type' 		=> 'logo',
				'transport'	=> 'postMessage'
			)
			
		);
		radium_add_customizer_section( 'header', __( 'Header', 'radium' ), $header_options, 2 );
		
		// Setup main styles options
		$main_styles_options = array(
			'main_bg' => array( 
				'name' 		=> __( 'Main Background Image', 'radium' ),
				'id' 		=> 'main_bg',
				'type' 		=> 'main_bg',
				'transport'	=> 'postMessage'
			),
			'boxed_bg_color' => array(	
				'name' 		=> __( 'Boxed Layout Background Color', 'radium' ),
				'id'		=> 'boxed_bg_color',
				'type' 		=> 'color',
				'transport'	=> 'postMessage'
			),
			'header_bg_color' => array(	
				'name' 		=> __( 'Header Background Color', 'radium' ),
				'id'		=> 'header_bg_color',
				'type' 		=> 'color',
				'transport'	=> 'postMessage'
			),
			'accent_color' => array( 
				'name' 		=> __( 'Accent Color', 'radium' ),
				'id' 		=> 'accent_color',
				'type' 		=> 'color',
				'transport'	=> 'postMessage'
			),
			'footer_bg_color' => array(	
				'name' 		=> __( 'Footer Background Color', 'radium' ),
				'id'		=> 'footer_bg_color',
				'type' 		=> 'color',
				'transport'	=> 'postMessage'
			)
			
		);
		radium_add_customizer_section( 'main_styles', __( 'Main Styles', 'radium' ), $main_styles_options, 3 );
		
		// Setup custom styles option
		$custom_styles_options = array(
			'custom_styles' => array( 
				'name' 		=> __( 'Enter styles to preview their results.', 'radium' ),
				'id' 		=> 'user_custom_styles',
				'type' 		=> 'textarea',
				'transport'	=> 'postMessage'
			)
		);
		radium_add_customizer_section( 'custom_css', __( 'Custom CSS', 'radium' ), $custom_styles_options, 121 );
	}
	add_action( 'after_setup_theme', 'singleton_customizer' );
	
}
?>