<?php
/**
 * The default template for displaying content
 */
 $framework = radium_framework();
 
 $options = $framework->options;
?>

<section id="post-<?php the_ID(); ?>" <?php post_class('clearfix'); ?>>		
	
	<?php if ( 'post' == get_post_type() ) : do_action( 'radium_post_format_icon' ); ?>
	
		<header class="entry-header">
		
			<?php if ( is_sticky() ) : ?>
	
				<?php if( is_singular() ) { ?>
				
					<h2 class="entry-title"><span><?php the_title(); ?></span></h2>
					<h3 class="entry-format"><?php _e( 'Featured', 'radium' ); ?></h3>
								
				<?php } else { ?>
				    
					<h2 class="entry-title"><span><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'radium' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php the_title(); ?></a></span></h2>
					<h3 class="entry-format"><?php _e( 'Featured', 'radium' ); ?></h3>
								
				<?php } ?>
				
			<?php else : ?>
	
				<?php if( is_singular() ) { ?>
				
					<h2 class="entry-title"><span><?php the_title(); ?></span></h2> 
					
				<?php } else { ?>
				
					<h2 class="entry-title">
						<span>
							<a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'radium' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php the_title(); ?></a>
						</span>
					</h2>
					
				<?php } ?>
				
			<?php endif; ?>
				
		</header><!-- .entry-header -->
		
			
		<?php
		
		$thumb_w = 940; //Define width
 		$thumb_h = ( is_singular() ) ? 999999 : 350 ;
  		$img_url = false;
  		$crop = ( is_singular() ) ? false : true;
  		
		//Check if post has a featured image set else get the first image from the gallery and use it. If both statements are false display fallback image. 
		if ( has_post_thumbnail() ) {
			
			//get featured image
		    $thumb = get_post_thumbnail_id();
		    $img_url = wp_get_attachment_url( $thumb,'full' ); //get full URL to image (use "large" or "medium" if the image is too big)
		  
		}
		
 		$image = $img_url ? radium_resize( $img_url, $thumb_w, $thumb_h, $crop ) : false ;
	
		if( $image ) {
			
			$caption = radium_get_the_featured_image_details( 'caption' );
			
			?>
		
			<div class="entry-content-media">
				<div class="post-thumb preload">
					<?php if( is_singular() ) { ?>
					    
						<img src="<?php echo $image; ?>" class="wp-post-image" width="<?php echo $thumb_w; ?>" height="<?php echo $thumb_h; ?>" alt="" />
						<?php if ($caption) { ?><div class="feature-caption"> <?php echo $caption; ?></div><?php } ?>
							
					<?php } else { ?>
					    
						<a title="<?php printf(__('Permanent Link to %s', 'radium'), get_the_title()); ?>" href="<?php the_permalink(); ?>">
							<img src="<?php echo $image; ?>" class="wp-post-image" width="<?php echo $thumb_w; ?>" height="<?php echo $thumb_h; ?>" alt="" />
						<?php 
							if ($caption) {  
								$caption = strip_tags($caption, '<p><br>'); //strip all except divs and p tags
							 ?><div class="feature-caption"> <?php echo $caption; ?></div><?php } ?>
						</a>
													
					<?php }  ?>
				</div>
			</div>
		<?php } //image ?> 		
		
		<?php do_action( 'radium_post_meta' ); ?>
			
		<article class="entry-content">
			<?php the_content( __( '<span>Continue Reading &rarr;</span>', 'radium' ) ); ?>
			<?php wp_link_pages( array( 'before' => '<div class="page-link"><span>' . __( 'Pages:', 'radium' ) . '</span>', 'after' => '</div>' ) ); ?>
		</article><!-- .entry-content -->
		
	<?php endif; ?>
	
</section><!-- #post-<?php the_ID(); ?> -->
