<?php
/**
 * The default template for displaying content
 */
 $framework = radium_framework();
 
 $options = $framework->options;
?>

<section id="post-<?php the_ID(); ?>" <?php post_class('clearfix'); ?>>		
	
	<?php if ( 'post' == get_post_type() ) : do_action( 'radium_post_format_icon' ); ?>
	
		<header class="entry-header">
		
			<?php if ( is_sticky() ) : ?>
	
				<?php if( is_singular() ) { ?>
				
					<h2 class="entry-title"><span><?php the_title(); ?></span></h2>
					<h3 class="entry-format"><?php _e( 'Featured', 'radium' ); ?></h3>
								
				<?php } else { ?>
				    
					<h2 class="entry-title"><span><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'radium' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php the_title(); ?></a></span></h2>
					<h3 class="entry-format"><?php _e( 'Featured', 'radium' ); ?></h3>
								
				<?php } ?>
				
			<?php else : ?>
	
				<?php if( is_singular() ) { ?>
				
					<h2 class="entry-title"><span><?php the_title(); ?></span></h2> 
					
				<?php } else { ?>
				
					<h2 class="entry-title">
						<span>
							<a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'radium' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php the_title(); ?></a>
						</span>
					</h2>
					
				<?php } ?>
				
			<?php endif; ?>
	
		</header><!-- .entry-header -->
		 
	    <div class="entry-content-media">
	        <?php 
	        	$embed = get_post_meta($post->ID, '_radium_video_embed', true);
	        	if( !empty($embed) ) {
	        		echo "<div class='video-frame'>";
	        	    echo stripslashes(htmlspecialchars_decode($embed));
	        	    echo "</div>";
	        	} else {
	        	    radium_video( $post->ID );
	        	}
	         ?>
         </div>
			
		<article class="entry-content">
			<?php do_action( 'radium_post_meta' ); ?>
		
			<?php the_content( __( '<span>Continue Reading &rarr;</span>', 'radium' ) ); ?>
			<?php wp_link_pages( array( 'before' => '<div class="page-link"><span>' . __( 'Pages:', 'radium' ) . '</span>', 'after' => '</div>' ) ); ?>
		</article><!-- .entry-content -->
		
	<?php endif; ?>
	
</section><!-- #post-<?php the_ID(); ?> -->
