
<?php 
$framework = radium_framework();

if ( is_tax( 'gallery_tag' ) ||  is_tax( 'gallery_collections' ) ) { // A few checks for Gallery archives ?>
	<div class="page-header page-entry-meta">
		<h1 class="entry-title">
			<span>
				<?php if ( is_tax( 'gallery_tag' ) ):?>
				
					<?php _e( 'Gallery Tag: ', 'radium' ); ?>
					<?php $i = 0; $term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) ); echo $term->name; ?>
					
				<?php else : ?>
				
					<?php _e( 'Gallery Collection: ', 'radium' ); ?>
					<?php $i = 0; $term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) ); echo $term->name; ?>
					
				<?php endif; ?>
			</span>
		</h1>
	</div>
<?php } elseif ( is_tax( 'portfolio_tag' ) ||  is_tax( 'portfolio_category' ) ) { // A few checks for Portfolio archives ?>
	<div class="page-header page-entry-meta">
		<h1 class="entry-title">
			<span>
				<?php if ( is_tax( 'portfolio_tag' ) ):?>
				
					<?php _e( 'Portfolio Tag: ', 'radium' ); ?>
					<?php $i = 0; $term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) ); echo $term->name; ?>
					
				<?php else : ?>
				
					<?php _e( 'Portfolio Category: ', 'radium' ); ?>
					<?php $i = 0; $term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) ); echo $term->name; ?>
					
				<?php endif; ?>
			</span>
		</h1>
	</div>
<?php } elseif (is_archive()) { // A few checks for archives ?>
	<div class="row page-entry-meta">
		<div class="twelve columns">
		    <h1 class="page-title">
		    	<span>
		    	    <?php 
		    	    if(is_tag() ): ?>
		    		    <?php printf( __( 'Tag Archives: %s', 'radium' ), '<span>' . single_tag_title( '', false ) . '</span>' ); ?>
		    		    <?php $tag_description = tag_description();
		    		    if ( ! empty( $tag_description ) )
		    		    	echo apply_filters( 'tag_archive_meta', '<div class="tag-archive-meta">' . $tag_description . '</div>' ); ?>
		    		<?php elseif (is_category() ) : ?>
		    		    <?php printf( __( 'Category Archives: %s', 'radium' ), '<span>' . single_cat_title( '', false ) . '</span>' ); ?>
		    		    <?php $category_description = category_description();
		    		    	if ( ! empty( $category_description ) )
		    		    		echo apply_filters( 'category_archive_meta', '<div class="category-archive-meta">' . $category_description . '</div>' ); ?>
		    		<?php elseif ( is_day() ) : ?>
		    			<?php printf( __( 'Daily Archives: %s', 'radium' ), '<span>' . get_the_date() . '</span>' ); ?>
		    		<?php elseif ( is_month() ) : ?>
		    			<?php printf( __( 'Monthly Archives: %s', 'radium' ), '<span>' . get_the_date( _x( 'F Y', 'monthly archives date format', 'radium' ) ) . '</span>' ); ?>
		    		<?php elseif ( is_year() ) : ?>
		    			<?php printf( __( 'Yearly Archives: %s', 'radium' ), '<span>' . get_the_date( _x( 'Y', 'yearly archives date format', 'radium' ) ) . '</span>' ); ?>
		    		<?php elseif ( is_author() ) : ?>
		    		    <?php _e( 'Author Archive', 'radium' ); ?> <span> <?php get_the_author(); ?></span>
		    		 <?php elseif (  $framework->theme_supports( 'plugin', 'bbpress' ) && bbp_get_topic_tag_tax_id() ) : ?>
		    		    <?php printf( __( 'Topic Tag: %s', 'radium' ), '<span>' . bbp_get_topic_tag_name() . '</span>' ); ?>
		    		<?php else : ?>
		    			<?php printf(  __( 'Archives', 'radium' ) ); ?>
		    		<?php endif; ?>
		    	</span>
		    </h1>
		</div>
	</div>	
<?php } elseif( is_search() ) { ?>	
	<h1 class="entry-title">
		<?php printf( __('Search Results for: &ldquo;%s&rdquo;', 'radium'), get_search_query()); ?>
	</h1>
<?php } elseif ( 'post'== get_post_type() ) { 
	//Get Blog Post Page ID, extract and show the title 	
	$blog = get_post(get_option('page_for_posts')); 
	
	?>
	<h1 class="entry-title">
		<span><?php echo $blog->post_title; ?></span>
	</h1>
	<?php if( get_post_meta( $blog->ID, '_radium_subtitle', true ) ) { ?><h3 class="subheader"><?php echo get_post_meta( $blog->ID, '_radium_subtitle', true ); ?></h3><?php } ?>
	
<?php } elseif ( 'page'== get_post_type() && is_front_page()) {
	//Get Frontpage Page ID, extract and show the title  	
	$frontpage = get_post(get_option('page_on_front')); ?>
	<h1 class="entry-title">
		<span><?php echo $frontpage->post_title; ?></span>
	</h1>
<?php } else { ?>
 	<h1 class="entry-title"><span><?php the_title(); ?></span></h1>
 	<?php
 	if ( !is_404() )
 		if( get_post_meta( $post->ID, '_radium_subtitle', true ) && !is_404() ) { ?><h3 class="subheader"><?php echo get_post_meta( $post->ID, '_radium_subtitle', true ); ?></h3><?php } ?>
<?php } ?>
