<?php
/** 
 * Register Tabs Element
 * @return array();
 */
function radium_builider_registar_tabs_element( $elements ) {
	
	//Tabs
	$element_tabs = array(
		array(
			'name' 		=> 'Tab',
	    	'type'		=> 'subgroup_start',
	    	'class'		=> 'tabs',
	    	//'clone'		=> true,
	    ),
	    
	   	array(
			'id' 		=> 'setup',
			'name'		=> __( 'Setup Tabs', 'radium' ),
			'desc'		=> __( 'Choose the number of tabs along with image for each one.', 'radium' ),
			'type'		=> 'tabs'
		),
		
		array(
			'name' => __('Tab title', 'radium'),
			'desc' => __('', 'radium'),
			'id' => 'tab_title',
			'std' => '',
			'type' => 'textarea',
			'clone' => true,
			'clone-group' => 'tab-clone-group',
		),
		
		array(
			'name' => __('Tab Content', 'radium'),
			'desc' => __('', 'radium'),
			'id' => 'tab_content',
			'std' => '',
			'type' => 'textarea',
			'clone' => true,
			'clone-group' => 'tab-clone-group',
		),
			
		array(
	    	'type'		=> 'subgroup_end'
	    )
	);
	
	$elements['tabs'] = array(
		'info' => array(
			'name' 	=> 'Tabs',
			'id'	=> 'tabs',
			'query'	=> 'none',
			'hook'	=> 'radium_tabs',
			'shortcode'	=> '[tabs]',
			'desc' 	=> __( 'Set of tabbed content', 'radium' )
		),
		'options' => $element_tabs
	);

	return $elements;
	
}
add_filter('radium_builder_elements', 'radium_builider_registar_tabs_element');	