<?php

/**
 * Display slider.
 *
 * @since 2.1.0
 *
 * @param string $slider Slug of custom-built slider to use
 */

if( ! function_exists( 'radium_builder_slider_element' ) ) {
	function radium_builder_slider_element(  $id, $settings, $location ) {
	
		// Die if there's no slider
		if( $settings['slider_id'] ) {
			
			echo do_shortcode('[slider id="'.$settings['slider_id'].'"]');
			
		} else {
 			
 			echo '<div class="messageBox warning">'.__( 'Oops! You have not selected a slider in your layout.', 'radium' ).'</div>';
 			
 			return;
		}
		
	}
}

add_action('radium_builder_slider', 'radium_builder_slider_element', 10, 3);