<?php
/**
 * Activate class for Radium_PriceTables.
 *
 *
 * @since 1.0.0
 *
 * @package	Radium_PriceTables
 * @author	Franklin M Gitonga
 */
class Radium_PriceTables_Activate {

	/**
	 * Holds a copy of the object for easy reference.
	 *
	 * @since 1.0.0
	 *
	 * @var object
	 */
	private static $instance;

	/**
	 * Constructor. Hooks all interactions to initialize the class.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
	
		self::$instance = $this;
		
 		/** Register hooks */
		register_activation_hook(dirname(dirname(__FILE__)), array( $this, 'activate'));
		
	}
	
	/**
	 * Activate the pricetable plugin
	 */
	function activate(){
		// Flush rules so we can view price table pages
		flush_rewrite_rules();
		
	}
	
}
