<?php 

get_header();  

$framework = radium_framework();

$options = $framework->options;

radium_sidebar_loader(); 

//before content action hook 
do_action('radium_before_portfolio'); 

if (have_posts()) : 

//before portfolio content action hook 
do_action('radium_before_portfolio_content');

while (have_posts()) : the_post();
 
$mediaType = get_post_meta($post->ID, '_radium_portfolio_type', true);
$portfolio_class = strtolower($mediaType); 

$image_w = 940; //Define width
//$image_h = 999; // Define height
				
?>
<div class="row">
<div class="portfolio-media eight columns portfolio-media-<?php echo $mediaType; ?>"> 
	<div class="entry-content-media">
		<?php 
			// get the media elements
		    switch ( $mediaType ) {
	                    
                case "slideshow": ?>
  	                <div class="row">
  	                	<div class="twelve columns">                
                    		<?php radium_gallery( $post->ID, $image_w , false, null, '_radium_portfolio_upload_images' ); ?>
                    	</div>
                    </div>
                    <?php break;

                case "video":
	                ?> 
	                <div class="row">
	                	<div class="twelve columns">
	                	<?php
	                    $embed = get_post_meta($post->ID, '_radium_portfolio_embed_code', true);
	                    if( !empty($embed) ) {
	                    	echo "<div class='video-frame'>";
	                        	echo stripslashes(htmlspecialchars_decode($embed));
	                        echo "</div>";
	                    } else {
	                        radium_video($post->ID);
	                    }
	                    ?>
	                    </div>
                    </div>
                    
                    <?php
                    break;

                case "audio":
                	?> 
                	<div class="row">
                		<div class="twelve columns">
                			<?php radium_audio($post->ID); ?>
		                </div>
		            </div>
		                <?php
                    break;
				
                default:
            		$thumb = get_post_thumbnail_id();
            		$img_url = wp_get_attachment_url( $thumb,'full' ); //get full URL to image (use "large" or "medium" if the image is too big)
            		$image = radium_resize( $img_url, $image_w , true ); //resize & crop the image
            		
            		//add thumbnail fallback
            		//if(empty($image)) $image = get_radium_first_post_image(true);
            		
            		if ( $image ) {
            			
            		?> 
            		<div class="row">
            			<div class="twelve columns">
            		    	<img src="<?php echo $image; ?>" class="wp-post-image" width="<?php echo $image_w; ?>"/>
             			</div>
             		</div>
             		
             		<?php
             		}
                    break;
			}
		?>
	</div>
</div>
<div id="main" class="four columns" role="main">
			
		<!-- BEGIN .entry-content -->
		<section <?php post_class("entry-content $portfolio_class") ?> id="post-<?php the_ID(); ?>">
 			   
 			        <div class="entry-content">
						<?php the_content(); ?>
					</div>
 					<div class=" portfolio-entry-meta">
				
						<?php 
						// get the meta information and display if available
						$portfolioDate = get_post_meta($post->ID, '_radium_portfolio_date', true); 
						$portfolioClient = get_post_meta($post->ID, '_radium_portfolio_client', true);
						$portfolioURL = get_post_meta($post->ID, '_radium_portfolio_url', true);
						
						if( !empty($portfolioClient) ) {
						    echo '<div class="client"><span class="icon-briefcase "></span>';
						    echo '<span class="client-link">' . $portfolioClient . '</span></div>';
						}
						
						if( !empty($portfolioDate) ) {
						    echo '<div class="date"><span class="icon-calendar"></span>';
						    echo '<span class="date"> ' . $portfolioDate . '</span></div>';
						}
						?>
						
						<?php if ( $cat_list = get_the_term_list( $post->ID, 'portfolio_category', '', '', '' ) ) { ?>
						
							<div class="tax">
								<span class="icon-file "></span>
								<span class="portfolio-tags">
									<?php the_terms($post->ID, 'portfolio_category', '', ', ', ''); ?>
								</span>
	 						</div>
	 						
						<?php } ?>
						
						<?php
						$post_tags = isset($options['post_tags']) ? $options['post_tags'] : false;
						
						if ( $post_tags && array_key_exists('portfolio', $post_tags) ) { ?>
							 
							 <?php if ( $tag_list = get_the_term_list( $post->ID, 'portfolio_tag', '', '', '' ) ) { ?>
							 	<div class="tags-list">
							 		<span class="entry-utility-prep entry-utility-prep-tag-links">
							 			<span class="icon-tag "></span>
							 		</span>
							 		<?php $tag_list = get_the_term_list( $post->ID, 'portfolio_tag', '', ', ', '' ); ?>
							 		<span class="portfolio-tags">
							 			<?php echo $tag_list; ?>
							 		</span>
							 	</div>
							 <?php } ?>

						<?php }
						
						edit_post_link( __( '[Edit]', 'radium' ), '<div class="edit-link">', '</div>' ); 
						    
					    if( !empty($portfolioURL) ) { ?>
					    	<div class="url">
					    		 <a class="project-link" target="_blank" href="<?php echo $portfolioURL; ?>"><?php _e('Launch Project','radium'); ?></a>
					    	</div>
					    <?php } ?>
					</div>
 					  				 				
			</article>
			<?php 
			
			$related_posts = isset($options['related_posts']) ? $options['related_posts'] : false;
			
			$related_items_count = 3;
			
		    $related = radium_get_posts_related_by_taxonomy($post->ID, 'portfolio_category', array('posts_per_page' => $related_items_count));
		    $i = 0;
		
			
			if ( ( $related_posts && array_key_exists('portfolio', $related_posts) ) && $related->have_posts()  ) {
			
			?>
		
		<?php } ?>
		
		<?php
		 //after content action hook 
			do_action('radium_after_portfolio_content'); 
			
			// If the theme supports comments in portfolios and comments are open or we have at least one comment, load up the comment template
			if( $framework->theme_supports( 'comments', 'portfolio' ) && ( comments_open() || '0' != get_comments_number() )  ) comments_template( '', true );  
			
		?>
		    
		</section>
			
		<!-- END .entry-content -->
		<?php endwhile; 
		
		do_action('radium_after_portfolio');
		
		else : 			
		
			get_template_part( 'includes/content/content', 'not-found' ); 
		?>
		
		
		<?php endif; wp_reset_postdata(); ?>
		
	</div><!-- #main -->
 
</div>
<div class="row">
	<div class="twelve columns">
		<!-- Related Portfolio Posts-->
		<?php
				
			if ( $related_items_count === 3 ) {
			
				$page_columns = 'three-columns';
				$thumb_w = 300; //Define width
				$thumb_h = 136; // Define height
			
			} else {
			
				$page_columns = 'four-columns';
				$thumb_w = 220; //Define width
				$thumb_h = 140; // Define height
			 
			}
		?>
		
		<div class="hr"></div>
		
		<div class="related-content clearfix">
			            
	     	<h4 class="entry-title"><span><?php _e('You may also like', 'radium') ?></span></h4>
	            
	          <?php while( $related->have_posts() ) : $related->the_post(); 
	            
	            //Check if post has a featured image set else get the first image from the gallery and use it. If both statements are false display fallback image. 
	            if ( has_post_thumbnail() ) {
	            	
	            	//get featured image
	                $thumb = get_post_thumbnail_id();
	                $img_url = wp_get_attachment_url( $thumb,'full' ); //get full URL to image (use "large" or "medium" if the image is too big)
	              
	            } else {
	            
	            	$attachments = get_children(
	                    array(
	                    	'post_parent' => get_the_ID(), 
	                    	'post_type' => 'attachment', 
	                    	'post_mime_type' => 'image', 
	                    	'orderby' => 'menu_order'
	                    )
	                );
	                
	                if ( ! is_array($attachments) ) continue;
	                	$count = count($attachments);
	                	$first_attachment = array_shift($attachments);
	                
	                 @$img_url = wp_get_attachment_url( $first_attachment->ID,'full' ); //get full URL to image (use "large" or "medium" if the image is too big)
	            
	            }
	            
	            $crop = true; //resize but retain proportions
	            $single = true; //return array
	            $image = radium_resize($img_url, $thumb_w, $thumb_h, $crop, $single);
	            
	            //fallback if all image urls are false
            	if(empty($image)) $image = get_radium_first_post_image(true);
			    ?>
	            	<article id="post-<?php the_ID(); ?>" class="page-grid-item <?php echo $page_columns; if($i%3==2) { echo ' last'; } ?>">
			    		<div class="grid-thumb">
		    				<a title="<?php printf(__('Permanent Link to %s', 'radium'), get_the_title()); ?>" href="<?php the_permalink(); ?>" data-width="<?php echo $thumb_w; ?>" data-height="<?php echo $thumb_h; ?>">
		    					<img src="<?php echo $image ?>" alt="<?php the_title();?>"/>
		    					<span class="post-thumb-overlay"><?php _e('View Project', 'radium'); ?></span>
		    				    <div class="stripes"></div>
		    				</a>
		    			</div>
					
		    			<h4><a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php printf(__('Permanent Link to %s', 'radium'), get_the_title()); ?>"> <?php the_title(); ?></a></h4>
		    			<div class="entry-summary">
		    				<?php //Check if excerpt field has content then display it, otherwise run for the hills LOL.
		    					if ( !empty( $post->post_excerpt ) ) :
		    						the_excerpt();
		    					endif;
		    				?>
		    			</div><!-- .entry-summary -->
	    			</article>	
	    			
				<?php $i++; ?>		
	        <?php endwhile; wp_reset_postdata(); ?>
		    </div>
		<!-- END .related Portfolio-->

	</div>
	
</div>

<?php get_footer(); ?>
