<?php

/*-----------------------------------------------------------------------------------
	Plugin Name: Latest Tweets Widget
-----------------------------------------------------------------------------------*/

// Add function to widgets_init that'll load our widget
add_action( 'widgets_init', 'radium_tweets_widgets' );

// Register widget
function radium_tweets_widgets() {
	register_widget( 'radium_Tweet_Widget' );
}

// Widget class
class radium_tweet_widget extends WP_Widget {


/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
 
 
/**
 * Register widget with WordPress.
 */
public function __construct() {

	$framework = radium_framework();
	
	parent::__construct(
 		'radium_tweet_widget', // Base ID
		'Tweets ('. $framework->theme_title .')', // Name
		array( 'description' => __( 'A widget that displays most recent tweet.', 'radium' ), )
	);
}

/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
	
function widget( $args, $instance ) {
	extract( $args );

	// Our variables from the widget settings
	$title = apply_filters('widget_title', $instance['title'] );
	$username = $instance['username'];
	$postcount = $instance['postcount'];
	$tweettext = $instance['tweettext'];
	//$style = $instance['style'];

	// Before widget (defined by theme functions file)
	echo $before_widget;

	// Display the widget title if one was input
	if ( $title )
		echo $before_title . $title . $after_title;
			
	// Display Latest Tweets
	 ?>
		
		<div id="twitter_div">
			<ul id="twitter_update_list">
				<li>&nbsp;</li>
			</ul>
            <?php if($tweettext != '') : ?>
				<a href="http://twitter.com/<?php echo $username ?>" id="twitter-link"><span class="icon"><span class="icon-twitter"></span></span><?php echo $tweettext ?></a>
            <?php endif; ?>
		</div>
		<script type="text/javascript" src="http://twitter.com/javascripts/blogger.js"></script>
		<script type="text/javascript" src="http://api.twitter.com/1/statuses/user_timeline.json?screen_name=<?php echo $username ?>&amp;callback=twitterCallback2&amp;count=<?php echo $postcount ?>"></script>
	<?php 

	// After widget (defined by theme functions file)
	echo $after_widget;
	
}


/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	
function update( $new_instance, $old_instance ) {
	$instance = $old_instance;

	// Strip tags to remove HTML (important for text inputs)
	$instance['title'] = strip_tags( $new_instance['title'] );
	$instance['username'] = strip_tags( $new_instance['username'] );
	$instance['postcount'] = strip_tags( $new_instance['postcount'] );
	$instance['tweettext'] = strip_tags( $new_instance['tweettext'] );
	//$instance['style'] = strip_tags( $new_instance['style'] );
 
	// No need to strip tags
 	return $instance;
}


/*-----------------------------------------------------------------------------------*/
/*	Widget Settings (Displays the widget settings controls on the widget panel)
/*-----------------------------------------------------------------------------------*/
	 
function form( $instance ) {
 	
	// Set up some default widget settings
	
	//$style = $instance[ 'style' ];
	
	
	$defaults = array(
	'title' => 'Our Twitter Feed',
	'username' => '',
	'postcount' => '4',
	'tweettext' => 'Follow Us',
	);
	
	$instance = wp_parse_args( (array) $instance, $defaults ); ?>

	<!-- Widget Title: Text Input -->
	<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
	</p>
	
	<br>
	<p><strong>Input your Twitter Info below: </strong></p>
	<!-- Username: Text Input -->
	<p>
		<label for="<?php echo $this->get_field_id( 'username' ); ?>"><?php _e('Twitter Username (e.g. @radiumthemes)', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'username' ); ?>" name="<?php echo $this->get_field_name( 'username' ); ?>" value="<?php echo $instance['username']; ?>" />
	</p>
	
	<!-- Postcount: Text Input -->
	<p>
		<label for="<?php echo $this->get_field_id( 'postcount' ); ?>"><?php _e('Number of Tweets (max 20)', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'postcount' ); ?>" name="<?php echo $this->get_field_name( 'postcount' ); ?>" value="<?php echo $instance['postcount']; ?>" />
	</p>
	
	<!-- Tweettext: Text Input -->
	<p>
		<label for="<?php echo $this->get_field_id( 'tweettext' ); ?>"><?php _e('Button Text (e.g. Follow Us)', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'tweettext' ); ?>" name="<?php echo $this->get_field_name( 'tweettext' ); ?>" value="<?php echo $instance['tweettext']; ?>" />
	</p>
	
	<!--
	<p>
		<label for="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>"><?php _e( 'Choose a Button Style: ', 'radium' ); ?></label>
		<select id="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'style' ) ); ?>">
			<option value="style1" <?php selected( 'style1', $style ); ?>><?php _e( 'Style 1 (Default)', 'radium' ); ?></option>
			<option value="style2" <?php selected( 'style2', $style ); ?>><?php _e( 'Style 2 (Dark)', 'radium' ); ?></option>
			<option value="style3" <?php selected( 'style3', $style ); ?>><?php _e( 'Style 3 (Twitter Blue)', 'radium' ); ?></option>
			<option value="style4" <?php selected( 'style4', $style ); ?>><?php _e( 'Style 4 (Text Only)', 'radium' ); ?></option>
		</select>
	</p>
	-->
	<br>	
	<?php
	}
}
?>
