<?php

// Add function to widgets_init that'll load our widget
add_action( 'widgets_init', 'radium_social_icons_widgets' );

// Register widget
function radium_social_icons_widgets() {
	register_widget( 'radium_Social_icons_Widget' );
}

// Widget class
class radium_social_icons_widget extends WP_Widget {


/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
 
/**
 * Register widget with WordPress.
 */
public function __construct() {

	$framework = radium_framework();
	
	parent::__construct(
 		'radium_social_icons_widget', // Base ID
		'Social Counter Widget ('. $framework->theme_title .')', // Name
		array( 'description' => __( 'A widget that allows the display and configuration of Social Counters.', 'radium' ), )
	);
}

/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
	
function widget( $args, $instance ) {
	extract( $args );

	// Our variables from the widget settings
	$title = apply_filters('widget_title', $instance['title'] );
	$style = $instance['style'];
	
	//Profiles 
	$twitterprofile = $instance['twitterprofile'];
	$twitteraction = $instance['twitteraction'];
	$facebookpage = $instance['facebookpage'];
	$facebookaction = $instance['facebookaction'];
	$dribbbleprofile = $instance['dribbbleprofile'];
	$dribbbleaction = $instance['dribbbleaction'];
	
	$desc = null;	
 	$desc = $instance['desc'];

	// Before widget (defined by theme functions file)
	echo $before_widget;

	/* Display Widget */
	/* Display the widget title if one was input (before and after defined by themes). */
	if ( $title )
		echo $before_title . $title . $after_title;
		
	 $style = $style ? $style : 'dark' ;	
	?>
		<!-- Social Counter -->
		<div class="social-bar">                      
            
           	<?php if ( $desc ) { echo '<p>'.$desc.'</p>'; } ?>
            	
            <ul <?php if ( $style ) { echo 'class="' .$style . '"'; } ?> >
				 				
				<?php if($twitterprofile != '') : ?>
				
	                <li>
	                    <a href="http://twitter.com/<?php echo $twitterprofile; ?>" target="_blank">
	                    	<span class="icon-wrapper count-icon-twitter"></span>
	                    </a>	
	                    <strong>
	                    	<?php echo $this->do_twitter_followers_count($twitterprofile); ?>
	                    	<span><?php _e('Followers','radium'); ?></span>
	                    </strong>
	                    <div class="action-link">
	                    	<a href="http://twitter.com/<?php echo $twitterprofile; ?>">
	                    		<?php echo $twitteraction; ?>
	                    	</a>
	                    </div>
	                </li>
				
				<?php endif; ?>
				
                 <?php if($facebookpage != '') : ?>
                 
                     <li>
                   		<a href="http://www.facebook.com/<?php echo $facebookpage; ?>" target="_blank">
                   			<span class="icon-wrapper count-icon-facebook"></span>
                         </a>
                        	<strong>
                        		<?php echo $this->do_count_facebook_likes( $facebookpage ); ?>
                        		<span><?php _e('Fans','radium'); ?></span>
                        	</strong>
                  		<div class="action-link">
                  			<a href="http://www.facebook.com/<?php echo $facebookpage; ?>">
                  				<?php echo $facebookaction; ?>
                  			</a>
                  		</div>
                     </li>
                     
                 	<?php endif; ?>
                 	
                 <?php if( $dribbbleprofile != '' ) : ?>
                      <li>
                     	<a href="http://dribbble.com/<?php echo $dribbbleprofile; ?>" target="_blank">
                     		<span class="icon-wrapper count-icon-dribbble"></span>
                     	</a>	
                     	<strong>
							<?php echo $this->do_count_dribbbler( $dribbbleprofile ); ?>
                     		<span><?php _e('Followers','radium'); ?></span>
                     	</strong>
                     	<div class="action-link">
                     		<a href="http://dribbble.com/<?php echo $dribbbleprofile; ?>">
                     			<?php echo $dribbbleaction; ?>
                     		</a>
                     	</div>
                     </li> 
                 <?php endif; ?>
                          
            </ul>
      	</div>
      <!--/Social Counter -->
		
		
	<?php
	// After widget (defined by theme functions file)
	echo $after_widget;
		
}


/*----------------------------------------------------------------------------------*/
/*	Twitter API Function
/*-----------------------------------------------------------------------------------*/
function do_twitter_followers_count( $screen_name = 'radiumthemes' ) {
	$key = 'rm__twit_followers_count_' . $screen_name;

	// Let's see if we have a cached version
	$followers_count = get_transient($key);
	if ($followers_count !== false)
		return $followers_count;
	else
	{
		// If there's no cached version we ask Twitter
		$response = wp_remote_get("http://api.twitter.com/1/users/show.json?screen_name={$screen_name}");
		if (is_wp_error($response))
		{
			// In case Twitter is down we return the last successful count
			return get_option($key);
		}
		else
		{
			// If everything's okay, parse the body and json_decode it
			$json = json_decode(wp_remote_retrieve_body($response));
			$count = $json->followers_count;

			// Store the result in a transient, expires after 1 day
			// Also store it as the last successful using update_option
			set_transient($key, $count, 60*60*24);
			update_option($key, $count);
			return $count;
		}
	}
}


 /*--------------------------------------------------*/
 /* Facebook API Function
 /*--------------------------------------------------*/

function do_count_facebook_likes( $account ) {
		
	// check for cached version
	$key = 'rm_counter_facebook_' . $account;
	$cache = get_transient($key);
	
	$followers = '';
	
	if( $cache === false ) {
		
		$url = "https://graph.facebook.com/$account"; 
		$response 	= wp_remote_get( $url );
				
		if( is_wp_error( $response ) ) 
			return;
		
		$xml = wp_remote_retrieve_body( $response );
		
		if( is_wp_error( $xml ) )
			return;
				
		if( $response['response']['code'] == 200 ) {
			
			$json = json_decode( $xml );
			
			$followers = $json->likes;
					
			set_transient($key, $followers, 60*5);
			
		}
		
	}  else {
	
		$followers = $cache;
			
	}
	
	return $followers;
}
	 	
/*--------------------------------------------------*/
/* Dribble API Function
/*--------------------------------------------------*/

function do_count_dribbbler( $account ) {
		
	// check for cached version
	$key = 'rm_counter_dribbble_' . $account;
	$cache = get_transient($key);
	
	if( $cache === false ) {
		
		$url = "http://api.dribbble.com/$account"; 
		$response 	= wp_remote_get( $url );
				
		if( is_wp_error( $response ) ) 
			return;
		
		$xml = wp_remote_retrieve_body( $response );
		
		if( is_wp_error( $xml ) )
			return;
		
		if( $response['headers']['status'] == 200 ) {
			
			$json = json_decode( $xml );
			
			$followers = $json->followers_count;
			
			set_transient($key, $followers, 60*5);
			
		}
		
	}  else {
	
		$followers = $cache;
			
	}
	
	return $followers;
}
	 	
/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	
function update( $new_instance, $old_instance ) {
	$instance = $old_instance;

	// Strip tags to remove HTML (important for text inputs)
	$instance['title'] = strip_tags( $new_instance['title'] );
	$instance['style'] = strip_tags( $new_instance['style'] );

	// No need to strip tags
	$instance['twitterprofile'] = $new_instance['twitterprofile'];
	$instance['twitteraction'] = $new_instance['twitteraction'];
	$instance['facebookpage'] = $new_instance['facebookpage'];
	$instance['facebookaction'] = $new_instance['facebookaction'];
	$instance['dribbbleprofile'] = $new_instance['dribbbleprofile'];
	$instance['dribbbleaction'] = $new_instance['dribbbleaction'];	
	$instance['desc'] = $new_instance['desc'];
 	
	return $instance;
}

/*-----------------------------------------------------------------------------------*/
/*	Widget Settings (Displays the widget settings controls on the widget panel)
/*-----------------------------------------------------------------------------------*/
	
function form( $instance ) {

	// Set up some default widget settings
	$style = $instance[ 'style' ];
	
	$defaults = array(
		'title' => 'Social Counter Widget',
		'twitterprofile' => 'radiumthemes',
		'twitteraction' => 'Follow us on Twitter',
		'facebookpage' => '',
		'facebookaction' => 'Become a Facebook Fan',
		'dribbbleprofile' => '',
		'dribbbleaction' => 'Follow us on Dribbble',
		'desc' => '',
		
	);
		
	$instance = wp_parse_args( (array) $instance, $defaults ); ?>

	<!-- Widget Title: Text Input -->
	<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
	</p>

	<!-- Display: Text Input -->	
	<p>
		<label for="<?php echo $this->get_field_id( 'desc' ); ?>"><?php _e('Optional Text:', 'radium') ?></label>
		<textarea class="widefat" rows="6" cols="15" id="<?php echo $this->get_field_id( 'desc' ); ?>" name="<?php echo $this->get_field_name( 'desc' ); ?>"><?php echo $instance['desc']; ?></textarea>
	</p>
	
	<p>
		<label for="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>"><?php _e( 'Choose a Style: ', 'radium' ); ?></label>
		<select id="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'style' ) ); ?>">
			<option value="style1" <?php selected( 'style1', $style ); ?>><?php _e( 'Style 1 (Default)', 'radium' ); ?></option>
			<option value="style2" <?php selected( 'style2', $style ); ?>><?php _e( 'Style 2 (Social Colors)', 'radium' ); ?></option>
			<option value="style3" <?php selected( 'style3', $style ); ?>><?php _e( 'Style 3 (Icons)', 'radium' ); ?></option>
			<option value="dark" <?php selected( 'dark', $style ); ?>><?php _e( 'Style 4 (Dark)', 'radium' ); ?></option>
		</select>
	</p>
	
	<br>
	<p><strong>1. Twitter </strong></p>	
	
	<!-- Twitter Profile: Text Input -->
	<p>
		<label for="<?php echo $this->get_field_id( 'twitterprofile' ); ?>"><?php _e('Twitter Username (e.g. radiumthemes):', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'twitterprofile' ); ?>" name="<?php echo $this->get_field_name( 'twitterprofile' ); ?>" value="<?php echo $instance['twitterprofile']; ?>" />
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id( 'twitteraction' ); ?>"><?php _e('Action Link Text:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'twitteraction' ); ?>" name="<?php echo $this->get_field_name( 'twitteraction' ); ?>" value="<?php echo $instance['twitteraction']; ?>" />
	</p>
	
	<br>
	<p><strong>2. Facebook </strong></p>	
	
	<!-- Facebook Page: Text Input -->
	<p>
		<label for="<?php echo $this->get_field_id( 'facebookpage' ); ?>"><?php _e('Facebook Page Name (e.g. RadiumThemes):', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'facebookpage' ); ?>" name="<?php echo $this->get_field_name( 'facebookpage' ); ?>" value="<?php echo $instance['facebookpage']; ?>" />
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id( 'facebookaction' ); ?>"><?php _e('Action Link Text:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'facebookaction' ); ?>" name="<?php echo $this->get_field_name( 'facebookaction' ); ?>" value="<?php echo $instance['facebookaction']; ?>" />
	</p>
	
	<br>
	<p><strong>3. Dribbble </strong></p>	
	
	<!-- Dribbble Profile: Text Input -->
	<p>
		<label for="<?php echo $this->get_field_id( 'dribbbleprofile' ); ?>"><?php _e('Dribbble Username:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'dribbbleprofile' ); ?>" name="<?php echo $this->get_field_name( 'dribbbleprofile' ); ?>" value="<?php echo $instance['dribbbleprofile']; ?>" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'dribbbleaction' ); ?>"><?php _e('Action Link Text:', 'radium') ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'dribbbleaction' ); ?>" name="<?php echo $this->get_field_name( 'dribbbleaction' ); ?>" value="<?php echo $instance['dribbbleaction']; ?>" />
	</p>
 			
	<?php
	}

} 	 	 
?>