// closure to avoid namespace collision
(function () {
	// create the plugin
	tinymce.create("tinymce.plugins.radiumShortcodes", {
	
		init: function ( ed, url ) {
			ed.addCommand("radiumPopup", function ( a, params ) {
				var popup = params.identifier;
				
				// load thickbox
				tb_show("Insert Shortcodes", url + "/popup.php?popup=" + popup + "&width=" + 800);
			});
		},
		
		// creates control instances based on the control's id.
		// our button's id is "radium_button"
		
		createControl: function ( btn, e ) {
			if ( btn == "radium_button" ) {	
				
				var a = this;
				
				// creates the button
				var btn = e.createSplitButton('radium_button', {
                    title: "Insert Shortcodes", // title of the button
					image: RadiumShortcodes.plugin_folder +"/tinymce/images/icon.png", // path to the button's image
					icons: false
                });
				
				//Render a DropDown Menu
                btn.onRenderMenu.add(function (c, b) {	
                				
					a.addWithPopup( b, "Alerts", "alert" );
					a.addWithPopup( b, "Audio", "audio" );
					a.addWithPopup( b, "Buttons", "button" );
					a.addWithPopup( b, "Call to Action", "cta");
					a.addWithPopup( b, "Carousel", "carousel" );			
					//a.addWithPopup( b, "Clients", "clients" );
					a.addWithPopup( b, "Columns", "columns");
					
					c = b.addMenu({
						title: "Dividers"
					});
 					a.addImmediate( c, "Horizontal Rule", "[hr]");
					//a.addImmediate( c, "Horizontal Rule w/ Top Link", "[hr top]");
					//a.addWithPopup( c, "Horizontal Rule w/Link", "hr_link");
					a.addImmediate( c, "Horizontal Invisible", "[hr_invisible]");
					
					c = b.addMenu({
						title: "Dropcaps"
					});
					
					a.addImmediate( c, "Dropcap Light", "[dropcap1]A[/dropcap1]");
					a.addImmediate( c, "Dropcap Red", "[dropcap2]A[/dropcap2]");
					a.addImmediate( c, "Dropcap Dark", "[dropcap3]A[/dropcap3]");
					a.addImmediate( c, "Dropcap Dark Circle", "[dropcap4]A[/dropcap4]");
					a.addWithPopup( b, "Header", "header");
					a.addImmediate( b, "Highlight", "<br>[highlight]highlighted text[/highlight]<br>" );
					a.addWithPopup( b, "Icon", "icon");
					a.addWithPopup( b, "Icon Boxes", "iconbox");
					a.addImmediate( b, "Inset Box", "<div class='inset'></div>" );
					a.addWithPopup( b, "Lists", "lists" );
					a.addWithPopup( b, "Map", "gmap" );
					a.addWithPopup( b, "Person", "person" );
					a.addWithPopup( b, "Progress", "progress" );
					a.addWithPopup( b, "Popup", "popup" );
 					a.addWithPopup( b, "Social Icons", "social-icons" );
					//a.addWithPopup( b, "Slogan", "slogan");
					a.addWithPopup( b, "Tabs","tabs");
					a.addWithPopup( b, "Toggles","toggle");
					a.addWithPopup( b, "Teaser","teaser");
					a.addWithPopup( b, "Testimonial","testimonial");
					a.addWithPopup( b, "Video", "video" );
					   
				});
                
                return btn;
			}
			
			return null;
		},
		
		addWithPopup: function ( ed, title, id ) {
			ed.add({
				title: title,
				onclick: function () {
					tinyMCE.activeEditor.execCommand("radiumPopup", false, {
						title: title,
						identifier: id
					})
				}
			})
		},

		//Insert shortcode into content
		addImmediate: function ( ed, title, sc) {
			ed.add({
				title: title,
				onclick: function () {
					tinyMCE.activeEditor.execCommand( "mceInsertContent", false, sc )
				}
			})
		},
		
		// creds
		getInfo: function () {
			return {
				longname : "Radium Shortcodes",
				author : 'Franklin M Gitonga',
				authorurl : 'http://radiumthemes.com/',
				infourl : 'http://wiki.moxiecode.com/',
				version : "1.0"
			};
		}
	});
	
	// add radiumShortcodes plugin
	tinymce.PluginManager.add("radiumShortcodes", tinymce.plugins.radiumShortcodes);
})();
