<?php

/********************* META BOX DEFINITIONS ***********************/

$prefix = '_radium_';

global $meta_boxes, $pagenow;
 
/********************* META BOX REGISTERING ***********************/

/* ---------------------------------------------------------------------- */
/*	Custom Post Type: Slider
/* ---------------------------------------------------------------------- */

$meta_boxes[] = array(
	'id'       => 'slider-slides-settings',
	'title'    => __('Slides', 'radium'),
	'pages'    => array('slider'),
	'context'  => 'normal',
	'priority' => 'high',
	'fields'   => array(
		array(
			'name' => __('The Slides', 'radium'),
			'id'   => $prefix . 'slider_slides',
			'type' => 'slider_slides',
			'std'  => '',
			'desc' => ''
		)
	)
); //This loads the slider manager

$arg = array(
		array(
			'name'    => __('Slider type', 'radium'),
			'id'      => $prefix . 'slider_type',
			'type'    => 'select',
			'std'     => 'flexslider',
			'desc'    => '',
			'options' => array(
				'content-carousel' 	=> 'Content-Carousel',
				'flexslider' 		=> 'Flexslider',
			)
	),
	
/*	 Content Carousel
--------------------------------------------------------------------- */
	array(
		'name'		=> 'Content Type',
		'id'		=> $prefix . 'content_carousel_pt',
		'type'		=> 'checkbox_list',
		'options'	=> array(
			'post'			=> 'Posts',
			'portfolio'		=> 'Portfolio',
			'gallery'		=> 'Gallery',
		),
		'std' => array(
			'1'     => 'post', 
			'0' 	=> 'portfolio', 
			'0'   	=> 'gallery'
		),
		'desc'		=> ''
	),

/*	Flexslider */
/* ---------------------------------------------------------------------- */
		array(
			'name'    => __('Transition', 'radium'),
			'id'      => $prefix . 'slider_transition',
			'type'    => 'select',
			'std'     => 'slide-horizontal',
			'desc'    => '',
			'options' => array(
				'fade' => 'Fade',
				'slide-horizontal' => 'Slide-Horizontal',
				'slide-vertical' => 'Slide-Vertical',
				)
		),
 		
		array(
			'name' => __('Autoplay', 'radium'),
			'id'   => $prefix . 'slider_autoplay',
			'type' => 'checkbox',
			'std'  => 1,
			'desc' => ''
		),
		
		array(
			'name' => __('Pause autoplay on mouseover', 'radium'),
			'id'   => $prefix . 'slider_pause_on_hover',
			'type' => 'checkbox',
			'std'  => 1,
			'desc' => 'This works if autoplay is enabled.'
		),
		
		 array(
		 	'name' => __('Show Direction Controls', 'radium'),
		 	'id'   => $prefix . 'slider_controls',
		 	'type' => 'checkbox',
		 	'std'  => 1,
		 	'desc' => 'Show next/prev arrows and bottom nav bars.'
		),
		
		/*array(
			'name' => __('Hide content box', 'radium'),
			'id'   => $prefix . 'slider_hide_content',
			'type' => 'checkbox',
			'std'  => 0,
			'desc' => ''
		), */
		
		array(
			'name' => __('Slideshow Speed', 'radium'),
			'id'   => $prefix . 'slidershow_speed',
			'type' => 'text',
			'std'  => '6000',
			'desc' => 'In milliseconds.'
		),
		
		array(
			'name' => __('Slider Animation Speed', 'radium'),
			'id'   => $prefix . 'slideranimation_speed',
			'type' => 'text',
			'std'  => '1000',
			'desc' => 'In milliseconds.'
		),
	

/*	 General
--------------------------------------------------------------------- */
	
	array(
		'name' => __('Container Height:', 'radium'),
		'id'   => $prefix . 'slider_height',
		'type' => 'text',
		'std'  => '400',
		'desc' => ''
	),
	
	array(
		'name' => __('Container Width:', 'radium'),
		'id'   => $prefix . 'slider_width',
		'type' => 'text',
		'std'  => '940',
		'desc' => ''
	), 
	
);

$meta_boxes[] = array(
	'id'       => 'slider-settings',
	'title'    => __('General Settings', 'radium'),
	'pages'    => array('slider'),
	'context'  => 'side',
	'priority' => 'default',
	'fields'   => apply_filters( 'radium_slider_setting_metaboxes', $arg )
);
	
