<?php

$framework = radium_framework();

$options = $framework->options;

$related_posts = $options['related_posts_type'];
$radium_show_related = $options['related_posts'];
				
if /* if the related is checked in admin options then show the related box */ ( $radium_show_related !== "" ) { ?>

	<div id="related-posts" class="clearfix">
				
		<h5><span><?php _e('Some Related Posts.', 'radium'); ?></span></h5>
					
		<?php
		
		global $post;
		
		$i = 1;  
        $start = 3;  
        
        $thumb_w = 220; //Define width
        $thumb_h = 138; // Define height
							
		if( $related_posts == 'cat' ) {
		
			$tags = wp_get_post_tags($post->ID);
			$tag_ids = array();
			
			if ( $tags ) {
				foreach($tags as $individual_tag)
					$tag_ids[] = $individual_tag->term_id;
			}
						
			$args = array(
				'tag__in' 				=> $tag_ids,
				'post__not_in' 			=> array($post->ID),
				'showposts'				=> 3, // Number of related posts that will be shown.
				'ignore_sticky_posts'	=>1
			);
					
		} else { // if type is categories 
			
			$cats = get_the_category($post->ID);
			$cat_ids = array();
			
			if ( $cats ) {
				foreach($cats as $individual_cat)
					$cat_ids[] = $individual_cat->cat_ID;
			}
			
			$args = array(
				'category__in' 			=> $cat_ids,
				'post__not_in' 			=> array($post->ID),
				'showposts'				=> 3, // Number of related posts that will be shown.
				'ignore_sticky_posts'	=>1
			);
						
		}// if type is category

		$my_query = new wp_query($args);
		$post_count = $my_query->post_count;
		
		if( $my_query->have_posts() ) : while ($my_query->have_posts()) : $my_query->the_post(); ?>

			<div class="page-grid-item three-columns <?php if($i % 3 == 0) : ?>last<?php endif; ?>">
			
				<div class="grid-thumb preload">
					<a title="<?php printf(__('Permanent Link to %s', 'radium'), get_the_title()); ?>" href="<?php the_permalink(); ?>" data-width="<?php echo $thumb_w; ?>" data-height="<?php echo $thumb_h; ?>">
						<?php 
						//Check if post has a featured image set else get the first image from the gallery and use it. If both statements are false display fallback image. 
						if ( has_post_thumbnail() ) {
							
							//get featured image
						    $thumb = get_post_thumbnail_id();
						    $img_url = wp_get_attachment_url( $thumb,'full' ); //get full URL to image (use "large" or "medium" if the image is too big)
						  	
						  	$crop = true; //resize but retain proportions
						  	$single = true; //return array
						  	$image = radium_resize($img_url, $thumb_w, $thumb_h, $crop, $single);
						  
						} 
						
						//add thumbnail fallback
						if(empty($image)) $image = get_radium_first_post_image(true); 
						
						?>
						<img src="<?php echo $image ?>" alt="<?php the_title();?>"/>
						<span class="post-thumb-overlay"><?php _e('View Post', 'radium'); ?></span>
						<div class="stripes"></div>
					</a>
				</div>
				
				<div class="entry-summary">
					<h6><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h6>
					<?php echo wp_trim_words( get_the_excerpt(), '10' );   ?>
				</div><!-- .entry-summary -->
			
			</div><!--column-->

  			<?php $i++; $start++; ?>

		<?php endwhile; endif; // tags loop ?>
			
		<?php wp_reset_query(); ?>  
                
	</div><!--related-->

<?php }