<?php

/**
 * Display map.
 *
 * @since 2.1.0
 *
 * @param string $map Slug of custom-built map to use
 */

if( ! function_exists( 'radium_builder_map_element' ) ) {
	function radium_builder_map_element(  $id, $settings, $location ) {
		/*
		'maptype' 	=> 'roadmap',  	// hybrid, satellite, roadmap, terrain
		'zoom'		=> 14,			// 1-19
		'address'	=> '',			// Ex: 6921 Brayton Drive, Anchorage, Alaska
		'html'		=> '',			// Will default to Address if left empty
		'popup'		=> 'true',		// true/false
		'width'		=> '',			// Leave blank for 100%, need to use 'px' or '%'
		'height'	=> '500px'	
		*/
				
		$html = $settings['html'];
		$address = $settings['address'];
		$height = $settings['height'];
		$width = $settings['width'];
		$zoom = $settings['zoom'];
 		$maptype = $settings['maptype'];
 		$popup = $settings['popup'];
 		
		$framework = radium_framework();
  		
		// Map type
		$maptype = strtoupper( $maptype );
		
		// HTML
		if( ! $html )
			$html = $address;
			
		// Width/Height
		$styles = 'height:'.$height.'px;';
		if( $width )
			$styles .='width:'.$width.';';
		 		
		// Unique ID
		$id = rand();
		
		// Start output
		ob_start();
		?>
		<!-- Include google map api-->	
		<script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=true"></script>
		
			<script type="text/javascript">
		jQuery(document).ready(function($) {
			$("#radium_gmap_<?php echo $id; ?>").gMap({
				maptype: "<?php echo $maptype; ?>",
				zoom: <?php echo $zoom; ?>,
				markers: [
					{
						address: "<?php echo $address; ?>",
						popup: <?php echo $popup; ?>,
						html: "<?php echo $html; ?>",
						icon: {
							image: "<?php echo $framework->theme_images_url .'/map_pointer_home.png'; ?>",
							iconsize: [60, 60],
							iconanchor: [12,46]
						}
						
					}
				],
				controls: {
					panControl: true,
					zoomControl: true,
					mapTypeControl: true,
					scaleControl: true,
					streetViewControl: false,
					overviewMapControl: false
				}
			});
		});
		</script>
		<div id="radium_gmap_<?php echo $id; ?>" class="radium-gmap" style="<?php echo $styles; ?>"></div>
 		<?php
 		
		echo ob_get_clean();
		
	}
}

add_action('radium_builder_map', 'radium_builder_map_element', 10, 3);