<?php
/** 
 * Register Columns Element
 * @return array();
 */
function radium_builder_registar_featured_element( $elements ) {

	// Setup array for pages select
	$pages_select = array();
	$pages = get_pages();
	if( ! empty( $pages ) )
		foreach( $pages as $page )
			$pages_select[$page->post_name] = $page->post_title;
	else
		$pages_select['null'] = __( 'No pages exist.', 'radium' );

 	// featured
	$element_featured = array(
	    array(
	    	'type'		=> 'subgroup_start'
	    ),
	    
		array(
	    	'id' 		=> 'featured_content',
			'name'		=> __( 'Content', 'radium' ),
			'desc'		=> __( 'Enter in the featured you\'d like to show. You may use basic HTML, and most shortcode.', 'radium' ),
			'type'		=> 'textarea',
  			
		),
		array(
			'id' 		=> 'featured_content_image',
			'name'		=> __( 'Background Image', 'radium' ),
			'desc'		=> __( 'Featured area image. Enter url to image here', 'radium' ),
			'type'		=> 'text',
				
		),
		array(
			'id' 		=> 'featured_style',
			'name'		=> __( 'Featured area style', 'radium' ),
			'desc'		=> __( '', 'radium' ),
			'type'		=> 'select',
			'options'	=> array(
				'' 	=> __( 'Default', 'radium' ),
		        'style1' 		=> __( 'Style 1', 'radium' ),
		        'style2'		=> __( 'Style 2', 'radium' ),
			),
		),
		array(
			'id' 		=> 'featured_color',
			'name'		=> __( 'Featured area color', 'radium' ),
			'desc'		=> __( '', 'radium' ),
			'type'		=> 'select',
			'options'	=> array(
				'' 	=> __( 'Default', 'radium' ),
		        'dark' 		=> __( 'Dark', 'radium' ),
		        'blue'		=> __( 'Blue', 'radium' ),
		        'red'		=> __( 'Red', 'radium' ),
		        'green'		=> __( 'Green', 'radium' ),
		        'lime'		=> __( 'Lime', 'radium' ),
		        'purple'	=> __( 'Purple', 'radium' ),
		        'grey'		=> __( 'Grey', 'radium' ),
		        'orange'	=> __( 'Orange', 'radium' )
		        
			),
		),
		array(
			'id' 		=> 'featured_alignment',
			'name'		=> __( 'Featured area text alignment', 'radium' ),
			'desc'		=> __( '', 'radium' ),
			'type'		=> 'select',
			'options'	=> array(
				'left' 	=> __( 'Left', 'radium' ),
		        'center' 		=> __( 'Center', 'radium' ),
		        'right'		=> __( 'Right', 'radium' )
			),
		),
		array(
	    	'type'		=> 'subgroup_end'
	    )
	);


	$elements['featured'] = array(
			'info' => array(
			'name' 	=> 'Featured Area',
			'id'	=> 'featured',
			'query'	=> 'none',
			'hook'	=> null,
			'shortcode'	=> false,
			'desc' 	=> __( 'featured from external page or current page', 'radium' )
		),
		'options' => $element_featured
	);
	
	return $elements;
	
}
add_filter('radium_builder_elements', 'radium_builder_registar_featured_element');	