<?php
/** 
 * Register Clients Element
 * @return array();
 */
function radium_builider_registar_clients_element( $elements ) {
	
	//Clients
	$element_clients = array(
		array(
			'name' 		=> 'Client',
	    	'type'		=> 'subgroup_start',
	    	'class'		=> 'clients',
	    	//'clone'		=> true,
	    ),
	    
	   	array(
			'id' 		=> 'setup',
			'name'		=> __( 'Setup Clients', 'radium' ),
			'desc'		=> __( 'Choose the number of clients along with image for each one.', 'radium' ),
			'type'		=> 'clients'
		),
		
		array(
			'name' => __('Client Logo', 'radium'),
			'desc' => __('', 'radium'),
			'id' => 'client_logo',
			'std' => '',
			'type' => 'upload',
			'clone' => true,
			'clone-group' => 'client-clone-group',
		),
		
		array(
			'name' => __('Client Name', 'radium'),
			'desc' => __('', 'radium'),
			'id' => 'client_name',
			'std' => '',
			'type' => 'textarea',
			'clone' => true,
			'clone-group' => 'client-clone-group',
		),
		
		array(
			'name' => __('Client Url', 'radium'),
			'desc' => __('', 'radium'),
			'id' => 'client_url',
			'std' => '',
			'type' => 'textarea',
			'clone' => true,
			'clone-group' => 'client-clone-group',
		),
			
		array(
	    	'type'		=> 'subgroup_end'
	    )
	);
	
	$elements['clients'] = array(
		'info' => array(
			'name' 	=> 'Clients',
			'id'	=> 'clients',
			'query'	=> 'none',
			'hook'	=> 'radium_clients',
			'shortcode'	=> '[clients]',
			'desc' 	=> __( 'Set of tabbed content', 'radium' )
		),
		'options' => $element_clients
	);

	return $elements;
	
}
add_filter('radium_builder_elements', 'radium_builider_registar_clients_element');	